@props([
    'name',
    'label',
    'checked' => false,
    'value' => '1',
    'help' => null,
])

@php
    $isChecked = old($name, $checked);
@endphp

<div class="mb-3">
    <div class="form-check">
        <input 
            class="form-check-input @error($name) is-invalid @enderror" 
            type="checkbox" 
            id="{{ $name }}" 
            name="{{ $name }}" 
            value="{{ $value }}"
            {{ $isChecked ? 'checked' : '' }}
            {{ $attributes }}
        >
        <label class="form-check-label" for="{{ $name }}">
            {{ $label }}
        </label>
        
        @error($name)
            <div class="invalid-feedback">{{ $message }}</div>
        @enderror
        
        @if($help)
            <div class="form-text">{{ $help }}</div>
        @endif
    </div>
</div>
