@props([
    'name',
    'label' => null,
    'options' => [],
    'value' => null,
    'required' => false,
    'help' => null,
    'inline' => false,
])

@php
    $value = $value ?? old($name);
@endphp

<div class="mb-3">
    @if($label)
        <label class="form-label">
            {{ $label }}
            @if($required)
                <span class="text-danger">*</span>
            @endif
        </label>
    @endif
    
    @foreach($options as $optionValue => $optionLabel)
        <div class="form-check {{ $inline ? 'form-check-inline' : '' }}">
            <input 
                class="form-check-input @error($name) is-invalid @enderror" 
                type="radio" 
                name="{{ $name }}" 
                id="{{ $name }}_{{ $loop->index }}" 
                value="{{ $optionValue }}"
                {{ $value == $optionValue ? 'checked' : '' }}
                @if($required && $loop->first) required @endif
                {{ $attributes }}
            >
            <label class="form-check-label" for="{{ $name }}_{{ $loop->index }}">
                {{ $optionLabel }}
            </label>
        </div>
    @endforeach
    
    @error($name)
        <div class="invalid-feedback d-block">{{ $message }}</div>
    @enderror
    
    @if($help)
        <div class="form-text">{{ $help }}</div>
    @endif
</div>
