@props([
    'title',
    'description' => null,
    'icon' => null,
])

<div class="mb-4 d-flex justify-content-between align-items-center">
    <div>
        @if($icon)
            <h5 class="mb-0">
                <i class="bi bi-{{ $icon }}"></i> {{ $title }}
            </h5>
        @else
            <h5 class="mb-0">{{ $title }}</h5>
        @endif
        
        @if($description)
            <p class="text-muted mb-0">{{ $description }}</p>
        @endif
    </div>
    
    @isset($actions)
        <div class="d-flex gap-2">
            {{ $actions }}
        </div>
    @endisset
</div>
