@props(['organization' => null, 'usage' => null])

@php
    if ($usage === null && $organization !== null) {
        $usageService = app(\App\Services\UsageTrackingService::class);
        $usage = $usageService->getUsageSummary($organization);
    }
@endphp

<div class="card">
    <div class="card-header">
        <h5 class="mb-0"><i class="bi bi-speedometer2"></i> Resource Usage</h5>
    </div>
    <div class="card-body">
        @if($usage)
        @foreach($usage as $metric => $data)
            <div class="mb-4">
                <div class="d-flex justify-content-between mb-2">
                    <span class="fw-bold">{{ ucfirst($metric) }}</span>
                    <span>
                        {{ $data['current'] }} / 
                        @if($data['unlimited'] ?? false)
                            <span class="text-success">Unlimited</span>
                        @else
                            {{ $data['limit'] }}
                        @endif
                    </span>
                </div>
                
                @if(!($data['unlimited'] ?? false))
                    <div class="progress" style="height: 20px;">
                        <div class="progress-bar 
                            @if($data['percentage'] >= 100) bg-danger
                            @elseif($data['percentage'] >= 90) bg-warning
                            @else bg-success
                            @endif" 
                            role="progressbar" 
                            style="width: {{ min($data['percentage'], 100) }}%"
                            aria-valuenow="{{ $data['percentage'] }}" 
                            aria-valuemin="0" 
                            aria-valuemax="100">
                            {{ round($data['percentage'], 1) }}%
                        </div>
                    </div>
                    
                    @if($data['percentage'] >= 100)
                        <small class="text-danger">
                            <i class="bi bi-exclamation-triangle"></i> Limit reached. 
                            @if($organization)
                            <a href="{{ route('subscription.plans') }}">Upgrade plan</a>
                            @endif
                        </small>
                    @elseif($data['percentage'] >= 90)
                        <small class="text-warning">
                            <i class="bi bi-exclamation-circle"></i> Approaching limit. 
                            @if($organization)
                            <a href="{{ route('subscription.plans') }}">Consider upgrading</a>
                            @endif
                        </small>
                    @endif
                @endif
            </div>
        @endforeach
        @else
        <p class="text-muted">No usage data available.</p>
        @endif
    </div>
</div>
