@props([
    'user',
    'size' => 'md',
    'showName' => false,
    'showDetails' => false,
])

@php
    $sizes = [
        'sm' => 32,
        'md' => 40,
        'lg' => 64,
        'xl' => 100,
    ];
    
    $pixelSize = $sizes[$size] ?? 40;
    $fontSize = $pixelSize / 2.5;
    
    // Get initials
    $firstName = $user->first_name ?? $user->name ?? '';
    $lastName = $user->last_name ?? '';
    $initials = strtoupper(substr($firstName, 0, 1) . substr($lastName, 0, 1));
    
    // Get full name
    $fullName = $user->full_name ?? $user->name ?? 'Unknown';
    
    // Get photo
    $photo = $user->photo ?? null;
@endphp

<div class="d-flex align-items-center {{ $attributes->get('class') }}">
    @if($photo)
        <img src="{{ asset('storage/' . $photo) }}"
             alt="{{ $fullName }}"
             class="rounded-circle {{ $showName || $showDetails ? 'me-2' : '' }}"
             style="width: {{ $pixelSize }}px; height: {{ $pixelSize }}px; object-fit: cover;">
    @else
        <div class="rounded-circle bg-primary text-white d-inline-flex align-items-center justify-content-center {{ $showName || $showDetails ? 'me-2' : '' }}"
             style="width: {{ $pixelSize }}px; height: {{ $pixelSize }}px; font-size: {{ $fontSize }}px;">
            {{ $initials }}
        </div>
    @endif
    
    @if($showName || $showDetails)
        <div>
            @if($showName)
                <div class="fw-medium">{{ $fullName }}</div>
            @endif
            
            @if($showDetails)
                @if(isset($user->employee_code))
                    <small class="text-muted">{{ $user->employee_code }}</small>
                @elseif(isset($user->email))
                    <small class="text-muted">{{ $user->email }}</small>
                @endif
            @endif
        </div>
    @endif
</div>
