@extends('layouts.app')

@section('title', 'Create Department')
@section('page-title', 'Create Department')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Departments', 'url' => auth()->user()->can('view_departments') ? route('departments.index') : null],
        ['label' => 'Create']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="table-card">
                <form action="{{ route('departments.store') }}" method="POST">
                    @csrf

                    <x-form.input name="name" label="Department Name" required autofocus />

                    <x-form.input name="code" label="Department Code" required placeholder="e.g., IT, HR, FIN" help="Unique code for the department" />

                    <x-form.textarea name="description" label="Description" rows="3" />

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.select 
                                name="parent_id" 
                                label="Parent Department" 
                                placeholder="No Parent (Top Level)"
                                :options="$departments->pluck('name', 'id')->toArray()"
                                help="Select parent department for hierarchy" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="manager_id" 
                                label="Department Manager" 
                                placeholder="No Manager"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' (' . $e->employee_code . ')'])->toArray()" />
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <x-form.color name="color" label="Department Color" :value="old('color', '#714b67')" help="Color for visual identification" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="active" 
                                label="Status" 
                                :value="old('active', '1')"
                                :options="['1' => 'Active', '0' => 'Inactive']" />
                        </div>
                    </div>

                    <x-form.actions submit-text="Create Department" :cancel-url="route('departments.index')" />
                </form>
            </div>
        </div>
    </div>
@endsection
