@extends('layouts.app')
@section('title', 'Department Details')
@section('page-title', $department->name)
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Departments', 'url' => auth()->user()->can('view_departments') ? route('departments.index') : null],
    ['label' => $department->name]
]" />

<x-alert />

<div class="row">
    <div class="col-md-4 mb-4">
        <x-info-card>
            <div class="icon-box mb-3" style="background-color: {{ $department->color }}20; color: {{ $department->color }}">
                <i class="bi bi-building"></i>
            </div>
            <h4>{{ $department->name }}</h4>
            <x-status-badge :status="$department->active ? 'active' : 'inactive'" class="mb-3" />
            @if($department->description)
                <p class="text-muted small">{{ $department->description }}</p>
            @endif
            <div class="mt-4 d-grid gap-2">
                @can('edit_departments')
                <a href="{{ route('departments.edit', $department) }}" class="btn btn-primary">
                    <i class="bi bi-pencil"></i> Edit Department
                </a>
                @endcan
                @can('delete_departments')
                <form action="{{ route('departments.destroy', $department) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger w-100"
                            onclick="return confirm('Are you sure? This will affect {{ $department->employees->count() }} employees.')">
                        <i class="bi bi-trash"></i> Delete Department
                    </button>
                </form>
                @endcan
            </div>
        </x-info-card>

        <x-info-card title="Department Information" class="mt-4">
            <table class="table table-sm">
                <x-detail-row label="Manager" :value="$department->manager->full_name ?? 'Not assigned'" />
                <x-detail-row label="Employees" :value="$department->employees->count()" />
                @if($department->parent)
                    <x-detail-row label="Parent Dept">
                        @can('view_departments')
                        <a href="{{ route('departments.show', $department->parent) }}">
                            {{ $department->parent->name }}
                        </a>
                        @else
                        {{ $department->parent->name }}
                        @endcan
                    </x-detail-row>
                @endif
                @if($department->children->count() > 0)
                    <x-detail-row label="Sub-departments" :value="$department->children->count()" />
                @endif
            </table>
        </x-info-card>
    </div>

    <div class="col-md-8 mb-4">
        @if($department->children->count() > 0)
            <x-info-card title="Sub-departments ({{ $department->children->count() }})" class="mb-4">
                <div class="row">
                    @foreach($department->children as $child)
                        <div class="col-md-6 mb-3">
                            <div class="card">
                                <div class="card-body">
                                    <div class="d-flex align-items-center">
                                        <div class="icon-box-sm me-3" style="background-color: {{ $child->color }}20; color: {{ $child->color }}">
                                            <i class="bi bi-building"></i>
                                        </div>
                                        <div>
                                            <h6 class="mb-0">
                                                @can('view_departments')
                                                <a href="{{ route('departments.show', $child) }}">{{ $child->name }}</a>
                                                @else
                                                {{ $child->name }}
                                                @endcan
                                            </h6>
                                            <small class="text-muted">{{ $child->employees->count() }} employees</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </x-info-card>
        @endif

        <x-info-card>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Department Employees ({{ $department->employees->count() }})</h5>
                @can('create_employees')
                <a href="{{ route('employees.create') }}" class="btn btn-sm btn-primary">
                    <i class="bi bi-plus-circle"></i> Add Employee
                </a>
                @endcan
            </div>

            @if($department->employees->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Photo</th>
                                <th>Name</th>
                                <th>Position</th>
                                <th>Email</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($department->employees as $employee)
                                <tr>
                                    <td>
                                        <x-user-avatar :user="$employee" size="40" />
                                    </td>
                                    <td>
                                        @can('view_employees')
                                        <a href="{{ route('employees.show', $employee) }}">
                                            {{ $employee->full_name }}
                                        </a>
                                        @else
                                        {{ $employee->full_name }}
                                        @endcan
                                        <br>
                                        <small class="text-muted">{{ $employee->employee_code }}</small>
                                    </td>
                                    <td>{{ $employee->position->name ?? 'N/A' }}</td>
                                    <td>{{ $employee->email }}</td>
                                    <td>
                                        <x-status-badge :status="$employee->status" />
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            @can('view_employees')
                                            <a href="{{ route('employees.show', $employee) }}"
                                               class="btn btn-outline-primary">
                                                <i class="bi bi-eye"></i>
                                            </a>
                                            @endcan
                                            @can('edit_employees')
                                            <a href="{{ route('employees.edit', $employee) }}"
                                               class="btn btn-outline-secondary">
                                                <i class="bi bi-pencil"></i>
                                            </a>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <x-empty-state 
                    icon="people"
                    message="No employees in this department" />
            @endif
        </x-info-card>
    </div>
</div>
@push('styles')
<style>
    .icon-box-sm {
        width: 40px;
        height: 40px;
        border-radius: 8px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 20px;
    }
</style>
@endpush
@endsection
