<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employee Account Created</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .email-wrapper {
            max-width: 600px;
            margin: 20px auto;
            background-color: #ffffff;
        }
        .header {
            background-color: #4F46E5;
            color: #ffffff;
            padding: 30px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 24px;
        }
        .content {
            padding: 30px 20px;
        }
        .info-box {
            background-color: #F3F4F6;
            border-left: 4px solid #4F46E5;
            padding: 15px;
            margin: 20px 0;
        }
        .credentials-box {
            background-color: #FEF3C7;
            border: 2px solid #F59E0B;
            padding: 15px;
            margin: 20px 0;
            border-radius: 4px;
        }
        .credential-item {
            margin: 10px 0;
        }
        .credential-label {
            font-weight: bold;
            color: #4F46E5;
        }
        .warning {
            background-color: #FEE2E2;
            border-left: 4px solid #DC2626;
            padding: 15px;
            margin: 20px 0;
        }
        .button {
            display: inline-block;
            background-color: #4F46E5;
            color: #ffffff;
            padding: 12px 30px;
            text-decoration: none;
            border-radius: 4px;
            margin: 20px 0;
        }
        .footer {
            background-color: #F9FAFB;
            padding: 20px;
            text-align: center;
            color: #6B7280;
            font-size: 14px;
        }
        ul {
            margin: 10px 0;
            padding-left: 20px;
        }
        li {
            margin: 8px 0;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header">
            <h1>Welcome to {{ config('app.name') }}!</h1>
        </div>

        <div class="content">
            <h2>Hello {{ $employee->first_name }} {{ $employee->last_name }},</h2>
            
            <p>Your employee account has been successfully created. Welcome to the team!</p>

            <div class="info-box">
                <h3 style="margin-top: 0;">Your Employee Details</h3>
                <p>
                    <strong>Employee Code:</strong> {{ $employee->employee_code }}<br>
                    <strong>Department:</strong> {{ $employee->department->name ?? 'Not assigned' }}<br>
                    <strong>Position:</strong> {{ $employee->position->name ?? 'Not assigned' }}<br>
                    <strong>Joining Date:</strong> {{ $employee->joining_date ? $employee->joining_date->format('F d, Y') : 'Not set' }}
                </p>
            </div>

            <div class="credentials-box">
                <h3 style="margin-top: 0;">Your Login Credentials</h3>
                
                <div class="credential-item">
                    <div class="credential-label">Email / Username:</div>
                    <div>{{ $user->email }}</div>
                </div>
                
                <div class="credential-item">
                    <div class="credential-label">Temporary Password:</div>
                    <div>{{ $password }}</div>
                </div>
            </div>

            <div class="warning">
                <strong>⚠️ Important Security Notice:</strong><br>
                Please change your password immediately after your first login for security purposes.
            </div>

            <div style="text-align: center;">
                <a href="{{ config('app.url') }}/login" class="button">Login to Your Account</a>
            </div>

            <h3>Getting Started:</h3>
            <ol>
                <li>Click the "Login to Your Account" button above</li>
                <li>Enter your email and temporary password</li>
                <li>You will be prompted to change your password</li>
                <li>Complete your profile information</li>
                <li>Explore the system features</li>
            </ol>

            <h3>Need Help?</h3>
            <p>If you have any questions or need assistance, please contact your HR department or system administrator.</p>
        </div>

        <div class="footer">
            <p>This is an automated message from {{ config('app.name') }}.<br>
            Please do not reply to this email.</p>
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. All rights reserved.</p>
        </div>
    </div>
</body>
</html>