@extends('layouts.app')

@section('title', 'Add Employee')
@section('page-title', 'Add New Employee')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees', 'url' => route('employees.index')],
        ['label' => 'Add Employee']
    ]" />

    <div class="table-card">
        <form action="{{ route('employees.store') }}" method="POST" enctype="multipart/form-data">
            @csrf

            <div class="row">
                <div class="col-md-12 mb-4">
                    <h5 class="border-bottom pb-2">Personal Information</h5>
                </div>

                <div class="col-md-4">
                    <x-form.input name="first_name" label="First Name" required />
                </div>

                <div class="col-md-4">
                    <x-form.input name="last_name" label="Last Name" required />
                </div>

                <div class="col-md-4">
                    <x-form.input type="email" name="email" label="Email" required />
                </div>

                <div class="col-md-4">
                    <x-form.input name="phone" label="Phone" />
                </div>

                <div class="col-md-4">
                    <x-form.input name="mobile" label="Mobile" />
                </div>

                <div class="col-md-4">
                    <x-form.input type="date" name="date_of_birth" label="Date of Birth" />
                </div>

                <div class="col-md-4">
                    <x-form.select 
                        name="gender" 
                        label="Gender"
                        :options="[
                            'male' => 'Male',
                            'female' => 'Female',
                            'other' => 'Other'
                        ]" />
                </div>

                <div class="col-md-4">
                    <x-form.select 
                        name="marital_status" 
                        label="Marital Status"
                        :options="[
                            'single' => 'Single',
                            'married' => 'Married',
                            'divorced' => 'Divorced',
                            'widowed' => 'Widowed'
                        ]" />
                </div>

                <div class="col-md-4">
                    <x-form.file name="photo" label="Photo" accept="image/*" />
                </div>

                <div class="col-md-12 mb-4 mt-3">
                    <h5 class="border-bottom pb-2">Kenya Statutory Information</h5>
                </div>

                <div class="col-md-4">
                    <x-form.input name="identification_id" label="National ID / Passport" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="kra_pin" 
                        label="KRA PIN"
                        placeholder="e.g. A123456789Z"
                        help="Required for payroll tax calculations" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="nhif_number" 
                        label="NHIF Number"
                        placeholder="e.g. 1234567890"
                        help="National Hospital Insurance Fund" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="nssf_number" 
                        label="NSSF Number"
                        placeholder="e.g. 123456789"
                        help="National Social Security Fund" />
                </div>

                <div class="col-md-4">
                    <x-form.input name="nationality" label="Nationality" :value="old('nationality', 'Kenyan')" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        type="number" 
                        name="basic_salary" 
                        label="Basic Salary (KES)"
                        step="0.01"
                        placeholder="0.00"
                        help="Monthly basic salary for payroll calculations" />
                </div>

                <div class="col-md-12 mb-3">
                    <h6 class="text-info">HELB Loan Information</h6>
                </div>

                <div class="col-md-6">
                    <x-form.checkbox name="has_helb_loan" label="Has HELB Loan" />
                </div>

                <div class="col-md-6">
                    <x-form.input 
                        type="number" 
                        name="helb_monthly_deduction" 
                        label="Monthly HELB Deduction (KES)"
                        step="0.01"
                        :value="old('helb_monthly_deduction', 0)"
                        placeholder="0.00"
                        help="Amount to deduct monthly for HELB loan" />
                </div>

                <div class="col-md-12 mb-4 mt-3">
                    <h5 class="border-bottom pb-2">Work Information</h5>
                </div>

                <div class="col-md-4">
                    <x-form.select 
                        name="department_id" 
                        label="Department"
                        :options="$departments->pluck('name', 'id')->toArray()" />
                </div>

                <div class="col-md-4">
                    <x-form.select 
                        name="position_id" 
                        label="Position"
                        :options="$positions->pluck('name', 'id')->toArray()" />
                </div>

                <div class="col-md-4">
                    <x-form.select 
                        name="manager_id" 
                        label="Manager"
                        :options="$managers->pluck('full_name', 'id')->toArray()" />
                </div>

                <div class="col-md-4">
                    <x-form.input type="date" name="joining_date" label="Joining Date" />
                </div>

                <div class="col-md-4">
                    <x-form.input type="email" name="work_email" label="Work Email" />
                </div>

                <div class="col-md-4">
                    <x-form.input name="work_location" label="Work Location" />
                </div>

                <div class="col-md-12 mb-4 mt-3">
                    <h5 class="border-bottom pb-2">Emergency Contact</h5>
                </div>

                <div class="col-md-4">
                    <x-form.input name="emergency_contact_name" label="Emergency Contact Name" />
                </div>

                <div class="col-md-4">
                    <x-form.input name="emergency_contact_phone" label="Emergency Contact Phone" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="emergency_contact_relation" 
                        label="Relationship"
                        placeholder="e.g. Spouse, Parent, Sibling" />
                </div>

                <div class="col-md-12 mb-4 mt-3">
                    <h5 class="border-bottom pb-2">Bank Information</h5>
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="bank_name" 
                        label="Bank Name"
                        placeholder="e.g. KCB Bank, Equity Bank" />
                </div>

                <div class="col-md-4">
                    <x-form.input name="bank_account_number" label="Account Number" />
                </div>

                <div class="col-md-4">
                    <x-form.input 
                        name="bank_account_holder" 
                        label="Account Holder Name"
                        placeholder="Name as it appears on bank account" />
                </div>

                <div class="col-md-12 mb-4 mt-3">
                    <h5 class="border-bottom pb-2">Address Information</h5>
                </div>

                <div class="col-md-12">
                    <x-form.textarea name="address" label="Address" rows="3" />
                </div>

                <div class="col-md-3">
                    <x-form.input name="city" label="City" />
                </div>

                <div class="col-md-3">
                    <x-form.input name="state" label="State" />
                </div>

                <div class="col-md-3">
                    <x-form.input name="zip_code" label="ZIP Code" />
                </div>

                <div class="col-md-3">
                    <x-form.input name="country" label="Country" />
                </div>
            </div>

            <x-form.button-group 
                cancelUrl="{{ route('employees.index') }}"
                submitText="Create Employee"
                submitIcon="bi-check-circle" />
        </form>
    </div>
@endsection

@push('scripts')
<script>
    // Handle HELB loan checkbox
    document.getElementById('has_helb_loan').addEventListener('change', function() {
        const helbDeductionField = document.getElementById('helb_monthly_deduction');
        if (this.checked) {
            helbDeductionField.removeAttribute('disabled');
            helbDeductionField.focus();
        } else {
            helbDeductionField.value = '0';
            helbDeductionField.setAttribute('disabled', 'disabled');
        }
    });

    // Auto-fill account holder name from employee name
    function updateAccountHolder() {
        const firstName = document.getElementById('first_name').value;
        const lastName = document.getElementById('last_name').value;
        const accountHolderField = document.getElementById('bank_account_holder');
        
        if (firstName && lastName && !accountHolderField.value) {
            accountHolderField.value = firstName + ' ' + lastName;
        }
    }

    document.getElementById('first_name').addEventListener('blur', updateAccountHolder);
    document.getElementById('last_name').addEventListener('blur', updateAccountHolder);

    // Initialize HELB field state
    document.addEventListener('DOMContentLoaded', function() {
        const helbCheckbox = document.getElementById('has_helb_loan');
        const helbDeductionField = document.getElementById('helb_monthly_deduction');
        
        if (!helbCheckbox.checked) {
            helbDeductionField.setAttribute('disabled', 'disabled');
        }
    });
</script>
@endpush
