@extends('layouts.app')

@section('title', 'Edit Employee')
@section('page-title', 'Edit Employee')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees', 'url' => auth()->user()->can('view_employees') ? route('employees.index') : null],
        ['label' => $employee->full_name, 'url' => auth()->user()->can('view_employees') ? route('employees.show', $employee) : null],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <form action="{{ route('employees.update', $employee) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="accordion accordion-flush" id="employeeAccordion">
                        <!-- Personal Information -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingPersonal">
                                <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#personalInfo" aria-expanded="true" aria-controls="personalInfo">
                                    <i class="bi bi-person me-2"></i> Personal Information
                                </button>
                            </h2>
                            <div id="personalInfo" class="accordion-collapse collapse show" aria-labelledby="headingPersonal" data-bs-parent="#employeeAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <x-form.input name="first_name" label="First Name" required :value="$employee->first_name" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="last_name" label="Last Name" required :value="$employee->last_name" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="employee_code" label="Employee Code" required :value="$employee->employee_code" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input type="email" name="email" label="Email" required :value="$employee->email" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input type="tel" name="phone" label="Phone" :value="$employee->phone" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input type="tel" name="mobile" label="Mobile" :value="$employee->mobile" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.input type="date" name="date_of_birth" label="Date of Birth" :value="$employee->date_of_birth?->format('Y-m-d')" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.select 
                                                name="gender" 
                                                label="Gender"
                                                :value="$employee->gender"
                                                :options="[
                                                    'male' => 'Male',
                                                    'female' => 'Female',
                                                    'other' => 'Other'
                                                ]" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.select 
                                                name="marital_status" 
                                                label="Marital Status"
                                                :value="$employee->marital_status"
                                                :options="[
                                                    'single' => 'Single',
                                                    'married' => 'Married',
                                                    'divorced' => 'Divorced'
                                                ]" />
                                        </div>

                                        <div class="col-md-3 mb-3">
                                            <label for="photo" class="form-label">Photo</label>
                                            <input type="file" class="form-control @error('photo') is-invalid @enderror"
                                                   id="photo" name="photo" accept="image/*">
                                            @error('photo')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                            @if($employee->photo)
                                                <small class="text-muted">Current photo exists</small>
                                            @endif
                                        </div>

                                        <!-- Kenya Statutory Information -->
                                        <div class="col-md-12 mb-3 mt-4">
                                            <h6 class="text-info border-bottom pb-2">Kenya Statutory Information</h6>
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="identification_id" label="National ID / Passport" :value="$employee->identification_id" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="nationality" label="Nationality" :value="$employee->nationality" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="kra_pin" 
                                                label="KRA PIN"
                                                :value="$employee->kra_pin"
                                                placeholder="e.g. A123456789Z"
                                                help="Required for payroll tax calculations" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="nhif_number" 
                                                label="NHIF Number"
                                                :value="$employee->nhif_number"
                                                placeholder="e.g. 1234567890"
                                                help="National Hospital Insurance Fund" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="nssf_number" 
                                                label="NSSF Number"
                                                :value="$employee->nssf_number"
                                                placeholder="e.g. 123456789"
                                                help="National Social Security Fund" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                type="number" 
                                                name="basic_salary" 
                                                label="Basic Salary (KES)"
                                                step="0.01"
                                                :value="$employee->basic_salary"
                                                placeholder="0.00"
                                                help="Monthly basic salary for payroll calculations" />
                                        </div>

                                        <!-- HELB Loan Information -->
                                        <div class="col-md-12 mb-3 mt-3">
                                            <h6 class="text-warning">HELB Loan Information</h6>
                                        </div>

                                        <div class="col-md-6">
                                            <x-form.checkbox 
                                                name="has_helb_loan" 
                                                label="Has HELB Loan"
                                                :checked="$employee->has_helb_loan" />
                                        </div>

                                        <div class="col-md-6">
                                            <x-form.input 
                                                type="number" 
                                                name="helb_monthly_deduction" 
                                                label="Monthly HELB Deduction (KES)"
                                                step="0.01"
                                                :value="$employee->helb_monthly_deduction"
                                                placeholder="0.00"
                                                help="Amount to deduct monthly for HELB loan" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Work Information -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingWork">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#workInfo" aria-expanded="false" aria-controls="workInfo">
                                    <i class="bi bi-briefcase me-2"></i> Work Information
                                </button>
                            </h2>
                            <div id="workInfo" class="accordion-collapse collapse" aria-labelledby="headingWork" data-bs-parent="#employeeAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <x-form.select 
                                                name="department_id" 
                                                label="Department" 
                                                required
                                                :value="$employee->department_id"
                                                :options="$departments->pluck('name', 'id')->toArray()" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.select 
                                                name="position_id" 
                                                label="Position" 
                                                required
                                                :value="$employee->position_id"
                                                :options="$positions->pluck('name', 'id')->toArray()" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.select 
                                                name="manager_id" 
                                                label="Manager"
                                                :value="$employee->manager_id"
                                                :options="$managers->filter(fn($m) => $m->id != $employee->id)->pluck('full_name', 'id')->toArray()" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                type="date" 
                                                name="joining_date" 
                                                label="Joining Date" 
                                                required
                                                :value="$employee->joining_date?->format('Y-m-d')" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input type="email" name="work_email" label="Work Email" :value="$employee->work_email" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="work_location" label="Work Location" :value="$employee->work_location" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.select 
                                                name="status" 
                                                label="Status" 
                                                required
                                                :value="$employee->status"
                                                :options="[
                                                    'active' => 'Active',
                                                    'on_leave' => 'On Leave',
                                                    'resigned' => 'Resigned',
                                                    'terminated' => 'Terminated'
                                                ]" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Emergency Contact -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingEmergency">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#emergencyInfo" aria-expanded="false" aria-controls="emergencyInfo">
                                    <i class="bi bi-person-exclamation me-2"></i> Emergency Contact
                                </button>
                            </h2>
                            <div id="emergencyInfo" class="accordion-collapse collapse" aria-labelledby="headingEmergency" data-bs-parent="#employeeAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <x-form.input name="emergency_contact_name" label="Emergency Contact Name" :value="$employee->emergency_contact_name" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="emergency_contact_phone" label="Emergency Contact Phone" :value="$employee->emergency_contact_phone" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="emergency_contact_relation" 
                                                label="Relationship"
                                                :value="$employee->emergency_contact_relation"
                                                placeholder="e.g. Spouse, Parent, Sibling" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Bank Information -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingBank">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#bankInfo" aria-expanded="false" aria-controls="bankInfo">
                                    <i class="bi bi-bank me-2"></i> Bank Information
                                </button>
                            </h2>
                            <div id="bankInfo" class="accordion-collapse collapse" aria-labelledby="headingBank" data-bs-parent="#employeeAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="bank_name" 
                                                label="Bank Name"
                                                :value="$employee->bank_name"
                                                placeholder="e.g. KCB Bank, Equity Bank" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input name="bank_account_number" label="Account Number" :value="$employee->bank_account_number" />
                                        </div>

                                        <div class="col-md-4">
                                            <x-form.input 
                                                name="bank_account_holder" 
                                                label="Account Holder Name"
                                                :value="$employee->bank_account_holder"
                                                placeholder="Name as it appears on bank account" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Address Information -->
                        <div class="accordion-item">
                            <h2 class="accordion-header" id="headingAddress">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#addressInfo" aria-expanded="false" aria-controls="addressInfo">
                                    <i class="bi bi-geo-alt me-2"></i> Address Information
                                </button>
                            </h2>
                            <div id="addressInfo" class="accordion-collapse collapse" aria-labelledby="headingAddress" data-bs-parent="#employeeAccordion">
                                <div class="accordion-body">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <x-form.textarea name="address" label="Address" rows="2" :value="$employee->address" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.input name="city" label="City" :value="$employee->city" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.input name="state" label="State" :value="$employee->state" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.input name="zip_code" label="ZIP Code" :value="$employee->zip_code" />
                                        </div>

                                        <div class="col-md-3">
                                            <x-form.input name="country" label="Country" :value="$employee->country" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <x-form.button-group 
                        cancelUrl="{{ route('employees.show', $employee) }}"
                        submitText="Update Employee"
                        submitIcon="bi-check-circle" />
                </form>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
<script>
    // Handle HELB loan checkbox
    document.getElementById('has_helb_loan').addEventListener('change', function() {
        const helbDeductionField = document.getElementById('helb_monthly_deduction');
        if (this.checked) {
            helbDeductionField.removeAttribute('disabled');
            helbDeductionField.focus();
        } else {
            helbDeductionField.value = '0';
            helbDeductionField.setAttribute('disabled', 'disabled');
        }
    });

    // Initialize HELB field state
    document.addEventListener('DOMContentLoaded', function() {
        const helbCheckbox = document.getElementById('has_helb_loan');
        const helbDeductionField = document.getElementById('helb_monthly_deduction');
        
        if (!helbCheckbox.checked) {
            helbDeductionField.setAttribute('disabled', 'disabled');
        }
    });
</script>
@endpush
