@extends('layouts.app')

@section('title', 'Employee Details')
@section('page-title', 'Employee Details')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Employees', 'url' => auth()->user()->can('view_employees') ? route('employees.index') : null],
        ['label' => $employee->full_name, 'active' => true]
    ]" />

    <div class="row">
        <div class="col-md-4 mb-4">
            <x-info-sidebar>
                <div class="text-center mb-4">
                    <x-user-avatar 
                        :name="$employee->full_name" 
                        :photo="$employee->photo" 
                        size="150" 
                        class="mb-3" />
                    
                    <h4>{{ $employee->full_name }}</h4>
                    <p class="text-muted">{{ $employee->employee_code }}</p>
                    <x-status-badge :status="$employee->status" />
                </div>

                <div class="d-grid gap-2">
                    @can('edit_employees')
                    <a href="{{ route('employees.edit', $employee) }}" class="btn btn-primary w-100 mb-2">
                        <i class="bi bi-pencil"></i> Edit Employee
                    </a>
                    @endcan
                    @can('view_employees')
                    <a href="{{ route('employees.documents.index', $employee) }}" class="btn btn-info w-100 mb-2">
                        <i class="bi bi-file-earmark-text"></i> Documents
                    </a>
                    @endcan
                    @can('manage_organizations') 
                    <form action="{{ route('employees.destroy', $employee) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100" onclick="return confirm('Are you sure?')">
                            <i class="bi bi-trash"></i> Delete Employee
                        </button>
                    </form>
                    @endcan
                </div>
            </x-info-sidebar>
        </div>

        <div class="col-md-8 mb-4">
            <div class="table-card">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#personal">Personal Info</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#statutory">Kenya Statutory</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#work">Work Info</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#attendance">Attendance</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#leaves">Leaves</a>
                    </li>
                </ul>

                <div class="tab-content mt-3">
                    <div id="personal" class="tab-pane fade show active">
                        <table class="table table-borderless">
                            <x-detail-row label="Email" :value="$employee->email" />
                            <x-detail-row label="Phone" :value="$employee->phone" />
                            <x-detail-row label="Mobile" :value="$employee->mobile" />
                            <x-detail-row label="Date of Birth" :value="$employee->date_of_birth?->format('M d, Y')" />
                            <x-detail-row label="Gender" :value="$employee->gender ? ucfirst($employee->gender) : null" />
                            <x-detail-row label="Marital Status" :value="$employee->marital_status ? ucfirst($employee->marital_status) : null" />
                            <x-detail-row label="Nationality" :value="$employee->nationality" />
                            <x-detail-row label="National ID / Passport" :value="$employee->identification_id" />
                            <x-detail-row label="Address">
                                {{ $employee->address ?? '' }}<br>
                                {{ $employee->city ?? '' }} {{ $employee->state ?? '' }} {{ $employee->zip_code ?? '' }}<br>
                                {{ $employee->country ?? '' }}
                            </x-detail-row>
                            @if($employee->emergency_contact_name)
                            <x-detail-row label="Emergency Contact">
                                {{ $employee->emergency_contact_name }}<br>
                                <small class="text-muted">{{ $employee->emergency_contact_phone }} ({{ $employee->emergency_contact_relation }})</small>
                            </x-detail-row>
                            @endif
                        </table>
                    </div>

                    <div id="statutory" class="tab-pane fade">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="text-info mb-3">Tax & Statutory Information</h6>
                                <table class="table">
                                    <tr>
                                        <th width="40%">KRA PIN</th>
                                        <td>
                                            {{ $employee->kra_pin ?? 'Not Set' }}
                                            @if(!$employee->kra_pin)
                                                <span class="badge bg-warning text-dark ms-2">Required for Payroll</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>NHIF Number</th>
                                        <td>
                                            {{ $employee->nhif_number ?? 'Not Set' }}
                                            @if(!$employee->nhif_number)
                                                <span class="badge bg-warning text-dark ms-2">Required</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>NSSF Number</th>
                                        <td>
                                            {{ $employee->nssf_number ?? 'Not Set' }}
                                            @if(!$employee->nssf_number)
                                                <span class="badge bg-warning text-dark ms-2">Required</span>
                                            @endif
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>Basic Salary</th>
                                        <td>
                                            @if($employee->basic_salary)
                                                <strong>KES {{ number_format($employee->basic_salary, 2) }}</strong>
                                            @else
                                                Not Set
                                                <span class="badge bg-warning text-dark ms-2">Required for Payroll</span>
                                            @endif
                                        </td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <h6 class="text-warning mb-3">HELB Loan Information</h6>
                                <table class="table">
                                    <tr>
                                        <th width="40%">Has HELB Loan</th>
                                        <td>
                                            @if($employee->has_helb_loan)
                                                <span class="badge bg-danger">Yes</span>
                                            @else
                                                <span class="badge bg-success">No</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @if($employee->has_helb_loan)
                                    <tr>
                                        <th>Monthly Deduction</th>
                                        <td><strong>KES {{ number_format($employee->helb_monthly_deduction, 2) }}</strong></td>
                                    </tr>
                                    @endif
                                </table>

                                @if($employee->bank_name)
                                <h6 class="text-success mb-3 mt-4">Bank Information</h6>
                                <table class="table">
                                    <tr>
                                        <th width="40%">Bank Name</th>
                                        <td>{{ $employee->bank_name }}</td>
                                    </tr>
                                    <tr>
                                        <th>Account Number</th>
                                        <td>{{ $employee->bank_account_number ?? 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <th>Account Holder</th>
                                        <td>{{ $employee->bank_account_holder ?? 'N/A' }}</td>
                                    </tr>
                                </table>
                                @endif

                                <!-- Payroll Eligibility Status -->
                                <div class="mt-4">
                                    <h6 class="mb-3">Payroll Eligibility</h6>
                                    @if($employee->hasCompleteKraInfo() && $employee->effective_basic_salary > 0)
                                        <div class="alert alert-success">
                                            <i class="bi bi-check-circle me-2"></i>
                                            <strong>Ready for Payroll</strong><br>
                                            <small>All required information is complete</small>
                                        </div>
                                    @else
                                        <div class="alert alert-warning">
                                            <i class="bi bi-exclamation-triangle me-2"></i>
                                            <strong>Incomplete Information</strong><br>
                                            <small>Missing: 
                                                @if(!$employee->kra_pin) KRA PIN @endif
                                                @if(!$employee->nhif_number) NHIF Number @endif
                                                @if(!$employee->nssf_number) NSSF Number @endif
                                                @if(!$employee->effective_basic_salary) Basic Salary @endif
                                            </small>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div id="work" class="tab-pane fade">
                        <table class="table table-borderless">
                            <x-detail-row label="Department" :value="$employee->department->name ?? null" />
                            <x-detail-row label="Position" :value="$employee->position->name ?? null" />
                            <x-detail-row label="Manager" :value="$employee->manager->full_name ?? null" />
                            <x-detail-row label="Joining Date" :value="$employee->joining_date?->format('M d, Y')" />
                            <x-detail-row label="Work Email" :value="$employee->work_email" />
                            <x-detail-row label="Work Location" :value="$employee->work_location" />
                        </table>
                    </div>

                    <div id="attendance" class="tab-pane fade">
                        <h6>Recent Attendance</h6>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Date</th>
                                    <th>Check In</th>
                                    <th>Check Out</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($employee->attendances as $attendance)
                                    <tr>
                                        <td>{{ $attendance->date->format('M d, Y') }}</td>
                                        <td>{{ $attendance->check_in ?? 'N/A' }}</td>
                                        <td>{{ $attendance->check_out ?? 'N/A' }}</td>
                                        <td>
                                            <span class="badge bg-{{ $attendance->status == 'present' ? 'success' : 'danger' }}">
                                                {{ ucfirst($attendance->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4" class="text-center">No attendance records</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div id="leaves" class="tab-pane fade">
                        <h6>Recent Leave Requests</h6>
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Type</th>
                                    <th>From</th>
                                    <th>To</th>
                                    <th>Days</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($employee->leaveRequests as $leave)
                                    <tr>
                                        <td>{{ $leave->leaveType->name }}</td>
                                        <td>{{ $leave->start_date->format('M d, Y') }}</td>
                                        <td>{{ $leave->end_date->format('M d, Y') }}</td>
                                        <td>{{ $leave->number_of_days }}</td>
                                        <td>
                                            <span class="badge badge-status-{{ $leave->status }}">
                                                {{ ucfirst($leave->status) }}
                                            </span>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">No leave requests</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
