@extends('errors.layout')

@section('title', $title ?? 'Validation Error')
@section('code', '422')

@section('content')
    <div class="error-icon text-warning">
        <i class="bi bi-exclamation-diamond"></i>
    </div>
    
    <p class="error-message">
        {{ $message ?? "The information you provided couldn't be processed. Please check your input and try again." }}
    </p>

    <div class="error-details">
        <h6><i class="bi bi-clipboard-check me-2"></i>Data Validation Failed</h6>
        <p>Some of the information you submitted doesn't meet our requirements. This helps ensure data quality and system security.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:history.back()" class="btn-primary-custom">
            <i class="bi bi-arrow-left"></i>
            Go Back & Fix
        </a>
        
        @auth
            <a href="{{ route('dashboard') }}" class="btn-secondary-custom">
                <i class="bi bi-house"></i>
                Go to Dashboard
            </a>
        @else
            <a href="{{ route('login') }}" class="btn-secondary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        @endauth
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-life-preserver"></i>
            Get Help
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-lightbulb me-1"></i>
            <strong>Tip:</strong> Check for required fields, correct formats (email, phone), and valid date ranges.
        </small>
    </div>
@endsection