@extends('errors.layout')

@section('title', $title ?? 'Too Many Requests')
@section('code', '429')

@section('content')
    <div class="error-icon text-warning">
        <i class="bi bi-hourglass-split"></i>
    </div>
    
    <p class="error-message">
        {{ $message ?? "Whoa there! You're making requests a bit too quickly. Please take a short break and try again in a few moments." }}
    </p>

    <div class="error-details">
        <h6><i class="bi bi-shield-check me-2"></i>Rate Limiting Protection</h6>
        <p>This security measure helps protect our system and ensures fair usage for all users. The limit will reset automatically after a short period.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:location.reload()" class="btn-primary-custom" id="retryBtn" disabled>
            <i class="bi bi-arrow-clockwise"></i>
            <span id="retryText">Try Again in <span id="countdown">30</span>s</span>
        </a>
        
        @auth
            <a href="{{ route('dashboard') }}" class="btn-secondary-custom">
                <i class="bi bi-house"></i>
                Go to Dashboard
            </a>
        @else
            <a href="{{ route('login') }}" class="btn-secondary-custom">
                <i class="bi bi-box-arrow-in-right"></i>
                Login
            </a>
        @endauth
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-question-circle"></i>
            Need Help?
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-info-circle me-1"></i>
            <strong>Tip:</strong> If you continue to see this message, try clearing your browser cache or contact support.
        </small>
    </div>
@endsection

@push('scripts')
<script>
    // Countdown timer for retry button
    let countdown = 30;
    const retryBtn = document.getElementById('retryBtn');
    const countdownSpan = document.getElementById('countdown');
    const retryText = document.getElementById('retryText');
    
    const timer = setInterval(function() {
        countdown--;
        countdownSpan.textContent = countdown;
        
        if (countdown <= 0) {
            clearInterval(timer);
            retryBtn.disabled = false;
            retryBtn.classList.remove('disabled');
            retryText.innerHTML = '<i class="bi bi-arrow-clockwise me-2"></i>Try Again';
        }
    }, 1000);
</script>
@endpush