@extends('errors.layout')

@section('title', $title ?? 'Service Unavailable')
@section('code', '503')

@section('content')
    <div class="error-icon text-info">
        <i class="bi bi-wrench-adjustable"></i>
    </div>
    
    <p class="error-message">
        {{ $message ?? "We're currently performing scheduled maintenance to improve your experience. The system will be back online shortly." }}
    </p>

    <div class="error-details">
        <h6><i class="bi bi-gear me-2"></i>Maintenance in Progress</h6>
        <p>Our team is working hard to enhance the system. This temporary downtime allows us to implement important updates and improvements.</p>
    </div>

    <div class="error-actions">
        <a href="javascript:location.reload()" class="btn-primary-custom">
            <i class="bi bi-arrow-clockwise"></i>
            Check Again
        </a>
        
        <a href="mailto:support@qayahrms.com" class="btn-success-custom">
            <i class="bi bi-envelope"></i>
            Contact Support
        </a>
    </div>

    <div class="mt-4">
        <small class="text-muted">
            <i class="bi bi-clock me-1"></i>
            <strong>Estimated Duration:</strong> Usually 15-30 minutes
            <br>
            <i class="bi bi-calendar me-1"></i>
            <strong>Started:</strong> {{ now()->format('M d, Y \a\t g:i A') }}
        </small>
    </div>
@endsection

@push('scripts')
<script>
    // Auto-refresh every 2 minutes
    setInterval(function() {
        location.reload();
    }, 120000);
    
    // Show a notification every 30 seconds
    setInterval(function() {
        console.log('Checking if service is back online...');
    }, 30000);
</script>
@endpush