@extends('layouts.app')
@section('title', 'Leave Request Details')
@section('page-title', 'Leave Request Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Leave Requests', 'url' => auth()->user()->can('viewAny', App\Models\LeaveRequest::class) ? route('leaves.index') : null],
    ['label' => 'Details']
]" />

<x-alert />

<div class="row">
    <div class="col-md-8 mb-4">
        <x-info-card>
            <div class="d-flex justify-content-between align-items-start mb-4">
                <div>
                    <h4 class="mb-2">{{ $leaveRequest->leaveType->name }}</h4>
                    <x-status-badge :status="$leaveRequest->status" class="fs-6" />
                </div>
                <div class="text-end">
                    @if($leaveRequest->status == 'pending')
                        @can('approve_leaves')
                        <form action="{{ route('leaves.approve', $leaveRequest) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-success">
                                <i class="bi bi-check-circle"></i> Approve
                            </button>
                        </form>
                        <form action="{{ route('leaves.reject', $leaveRequest) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-danger">
                                <i class="bi bi-x-circle"></i> Reject
                            </button>
                        </form>
                        @endcan
                        @can('update', $leaveRequest)
                        <a href="{{ route('leaves.edit', $leaveRequest) }}" class="btn btn-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        @endcan
                    @endif
                    @if($leaveRequest->status == 'pending' || $leaveRequest->status == 'approved')
                        @can('cancel_leaves')
                        <form action="{{ route('leaves.cancel', $leaveRequest) }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-warning" onclick="return confirm('Cancel this leave request?')">
                                <i class="bi bi-slash-circle"></i> Cancel
                            </button>
                        </form>
                        @endcan
                    @endif
                </div>
            </div>

            <div class="row mb-4">
                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Leave Duration</h6>
                    <div class="d-flex align-items-center mb-3">
                        <div class="icon-box me-3" style="background-color: #28a74520; color: #28a745;">
                            <i class="bi bi-calendar-event"></i>
                        </div>
                        <div>
                            <div class="text-muted small">Start Date</div>
                            <div class="fw-bold">{{ $leaveRequest->start_date->format('l, F d, Y') }}</div>
                        </div>
                    </div>
                    <div class="d-flex align-items-center mb-3">
                        <div class="icon-box me-3" style="background-color: #dc354520; color: #dc3545;">
                            <i class="bi bi-calendar-x"></i>
                        </div>
                        <div>
                            <div class="text-muted small">End Date</div>
                            <div class="fw-bold">{{ $leaveRequest->end_date->format('l, F d, Y') }}</div>
                        </div>
                    </div>
                    <div class="d-flex align-items-center">
                        <div class="icon-box me-3" style="background-color: #007bff20; color: #007bff;">
                            <i class="bi bi-clock"></i>
                        </div>
                        <div>
                            <div class="text-muted small">Total Duration</div>
                            <div class="fw-bold">{{ $leaveRequest->number_of_days }} Days</div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <h6 class="text-muted mb-3">Request Information</h6>
                    <table class="table table-sm">
                        <x-detail-row label="Applied On" :value="$leaveRequest->created_at->format('M d, Y H:i')" />
                        @if($leaveRequest->approved_by)
                            <x-detail-row label="Approved By" :value="$leaveRequest->approver->full_name ?? 'N/A'" />
                            <x-detail-row label="Approved On" :value="$leaveRequest->approved_at?->format('M d, Y H:i') ?? 'N/A'" />
                        @endif
                        @if($leaveRequest->status == 'rejected' && $leaveRequest->rejection_reason)
                            <x-detail-row label="Rejection Reason">
                                <span class="text-danger">{{ $leaveRequest->rejection_reason }}</span>
                            </x-detail-row>
                        @endif
                    </table>
                </div>
            </div>

            <hr>

            <h6 class="text-muted mb-3">Reason for Leave</h6>
            <div class="bg-light p-3 rounded">
                {{ $leaveRequest->reason }}
            </div>

            @if($leaveRequest->notes)
                <hr>
                <h6 class="text-muted mb-3">Additional Notes</h6>
                <div class="bg-light p-3 rounded">
                    {{ $leaveRequest->notes }}
                </div>
            @endif
        </x-info-card>
    </div>

    <div class="col-md-4 mb-4">
        <x-info-card class="text-center mb-3">
            <x-user-avatar :user="$leaveRequest->employee" size="100" class="mb-3" />
            <h5>{{ $leaveRequest->employee->full_name }}</h5>
            <p class="text-muted mb-2">{{ $leaveRequest->employee->employee_code }}</p>
            <p class="text-muted mb-3">{{ $leaveRequest->employee->department->name ?? 'N/A' }}</p>
            @can('view_employees')
            <a href="{{ route('employees.show', $leaveRequest->employee) }}" class="btn btn-outline-primary btn-sm">
                <i class="bi bi-person"></i> View Profile
            </a>
            @endcan
        </x-info-card>

        <x-info-card title="Leave Balance" icon="calendar-check">
            @if($leaveRequest->employee->leaveBalances->count() > 0)
                <table class="table table-sm">
                    @foreach($leaveRequest->employee->leaveBalances as $balance)
                        <tr>
                            <td>
                                <span class="badge" style="background-color: {{ $balance->leaveType->color }}">
                                    {{ $balance->leaveType->name }}
                                </span>
                            </td>
                            <td class="text-end">
                                <strong>{{ $balance->available_days }}</strong> / {{ $balance->total_days }}
                            </td>
                        </tr>
                    @endforeach
                </table>
            @else
                <p class="text-muted text-center">No leave balance information</p>
            @endif
        </x-info-card>

        <x-info-card title="Recent Leaves" icon="clock-history" class="mt-3">
            <div class="list-group list-group-flush">
                @foreach($leaveRequest->employee->leaveRequests()->where('id', '!=', $leaveRequest->id)->latest()->take(5)->get() as $recent)
                    <div class="list-group-item px-0">
                        <div class="d-flex justify-content-between">
                            <small>{{ $recent->leaveType->name }}</small>
                            <x-status-badge :status="$recent->status" />
                        </div>
                        <small class="text-muted">
                            {{ $recent->start_date->format('M d') }} - {{ $recent->end_date->format('M d, Y') }}
                        </small>
                    </div>
                @endforeach
            </div>
        </x-info-card>
    </div>
</div>
@endsection
