@extends('layouts.app')

@section('title', 'Edit Loan - ' . $loan->loan_number)

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-8 offset-md-2">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title mb-0">Edit Loan - {{ $loan->loan_number }}</h3>
                </div>
                <div class="card-body">
                    <form action="{{ route('loans.update', $loan) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="employee_id" 
                                    label="Employee" 
                                    required
                                    :value="$loan->employee_id"
                                    :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' (' . $e->employee_code . ')'])->toArray()" />
                            </div>

                            <div class="col-md-6">
                                <x-form.select 
                                    name="loan_type" 
                                    label="Loan Type" 
                                    required
                                    :value="$loan->loan_type"
                                    :options="[
                                        'salary_advance' => 'Salary Advance',
                                        'emergency' => 'Emergency',
                                        'personal' => 'Personal',
                                        'education' => 'Education',
                                        'housing' => 'Housing',
                                        'other' => 'Other'
                                    ]" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <x-form.input 
                                    type="number" 
                                    name="principal_amount" 
                                    label="Principal Amount (KES)" 
                                    required
                                    step="0.01"
                                    min="1"
                                    :value="$loan->principal_amount" />
                            </div>

                            <div class="col-md-4">
                                <x-form.input 
                                    type="number" 
                                    name="interest_rate" 
                                    label="Interest Rate (% Annual)" 
                                    required
                                    step="0.01"
                                    min="0"
                                    max="100"
                                    :value="$loan->interest_rate"
                                    help="Enter 0 for interest-free loans" />
                            </div>

                            <div class="col-md-4">
                                <x-form.input 
                                    type="number" 
                                    name="repayment_period_months" 
                                    label="Repayment Period (Months)" 
                                    required
                                    min="1"
                                    max="60"
                                    :value="$loan->repayment_period_months" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    type="date" 
                                    name="disbursement_date" 
                                    label="Disbursement Date" 
                                    required
                                    :value="$loan->disbursement_date->format('Y-m-d')" />
                            </div>

                            <div class="col-md-6">
                                <x-form.input 
                                    type="date" 
                                    name="first_deduction_date" 
                                    label="First Deduction Date" 
                                    required
                                    :value="$loan->first_deduction_date->format('Y-m-d')" />
                            </div>
                        </div>

                        <x-form.textarea 
                            name="purpose" 
                            label="Purpose"
                            rows="3"
                            :value="$loan->purpose"
                            placeholder="Describe the purpose of this loan..." />

                        <x-form.textarea 
                            name="terms_conditions" 
                            label="Terms & Conditions"
                            rows="4"
                            :value="$loan->terms_conditions"
                            placeholder="Enter any terms and conditions for this loan..." />

                        <x-form.button-group 
                            cancelUrl="{{ route('loans.show', $loan) }}"
                            submitText="Update Loan"
                            submitIcon="bi-save" />
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
