@extends('layouts.app')

@section('title', 'Employee Loans')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header title="Employee Loans" description="Manage employee loan applications">
                <x-slot:actions>
                    @can('manage_payroll')
                    <a href="{{ route('loans.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus-circle"></i> New Loan
                    </a>
                    @endcan
                </x-slot:actions>
            </x-page-header>

            <x-alert type="success" :message="session('success')" />

            <!-- Filters -->
            <x-filter-form :action="route('loans.index')">
                <div class="col-md-3">
                    <label for="employee_id" class="form-label">Employee</label>
                    <select name="employee_id" id="employee_id" class="form-select">
                        <option value="">All Employees</option>
                        @foreach($employees as $employee)
                            <option value="{{ $employee->id }}" {{ request('employee_id') == $employee->id ? 'selected' : '' }}>
                                {{ $employee->full_name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="status" class="form-label">Status</label>
                    <select name="status" id="status" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>Pending</option>
                        <option value="approved" {{ request('status') == 'approved' ? 'selected' : '' }}>Approved</option>
                        <option value="disbursed" {{ request('status') == 'disbursed' ? 'selected' : '' }}>Disbursed</option>
                        <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                        <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                        <option value="defaulted" {{ request('status') == 'defaulted' ? 'selected' : '' }}>Defaulted</option>
                        <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="loan_type" class="form-label">Loan Type</label>
                    <select name="loan_type" id="loan_type" class="form-select">
                        <option value="">All Types</option>
                        <option value="salary_advance" {{ request('loan_type') == 'salary_advance' ? 'selected' : '' }}>Salary Advance</option>
                        <option value="emergency" {{ request('loan_type') == 'emergency' ? 'selected' : '' }}>Emergency</option>
                        <option value="personal" {{ request('loan_type') == 'personal' ? 'selected' : '' }}>Personal</option>
                        <option value="education" {{ request('loan_type') == 'education' ? 'selected' : '' }}>Education</option>
                        <option value="housing" {{ request('loan_type') == 'housing' ? 'selected' : '' }}>Housing</option>
                        <option value="other" {{ request('loan_type') == 'other' ? 'selected' : '' }}>Other</option>
                    </select>
                </div>
            </x-filter-form>

            <!-- Loans Table -->
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Loan Number</th>
                                    <th>Employee</th>
                                    <th>Type</th>
                                    <th>Principal</th>
                                    <th>Total Amount</th>
                                    <th>Balance</th>
                                    <th>Monthly Deduction</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($loans as $loan)
                                <tr>
                                    <td><code>{{ $loan->loan_number }}</code></td>
                                    <td>{{ $loan->employee->full_name }}</td>
                                    <td><span class="badge bg-info">{{ ucwords(str_replace('_', ' ', $loan->loan_type)) }}</span></td>
                                    <td>KES {{ number_format($loan->principal_amount, 2) }}</td>
                                    <td>KES {{ number_format($loan->total_amount, 2) }}</td>
                                    <td>KES {{ number_format($loan->balance, 2) }}</td>
                                    <td>KES {{ number_format($loan->monthly_deduction, 2) }}</td>
                                    <td>
                                        @php
                                            $statusColors = [
                                                'pending' => 'warning',
                                                'approved' => 'info',
                                                'disbursed' => 'primary',
                                                'active' => 'success',
                                                'completed' => 'secondary',
                                                'defaulted' => 'danger',
                                                'cancelled' => 'dark'
                                            ];
                                        @endphp
                                        <span class="badge bg-{{ $statusColors[$loan->status] ?? 'secondary' }}">
                                            {{ ucfirst($loan->status) }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('loans.show', $loan) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        @can('manage_payroll')
                                            @if($loan->status === 'pending')
                                                <a href="{{ route('loans.edit', $loan) }}" class="btn btn-sm btn-outline-secondary">
                                                    <i class="bi bi-pencil"></i>
                                                </a>
                                            @endif
                                        @endcan
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center py-4">
                                        <i class="bi bi-inbox" style="font-size: 3rem; color: #ccc;"></i>
                                        <p class="text-muted mt-2">No loans found</p>
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $loans->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
