@extends('onboarding.layout')

@section('title', 'Setup Complete')

@section('content')
<div class="step-indicator">
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Welcome</div>
    </div>
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Select Plan</div>
    </div>
    <div class="step completed">
        <div class="step-circle"><i class="bi bi-check"></i></div>
        <div class="step-label">Payment</div>
    </div>
    <div class="step active">
        <div class="step-circle">4</div>
        <div class="step-label">Complete</div>
    </div>
</div>

<div class="text-center mb-4">
    <i class="bi bi-check-circle text-success" style="font-size: 5rem;"></i>
    <h3 class="mt-3">You're All Set!</h3>
    <p class="text-muted">Your organization is ready to use Qaya HRM</p>
</div>

<div class="card mb-4">
    <div class="card-body">
        <h5><i class="bi bi-star"></i> Your Subscription</h5>
        <div class="row mt-3">
            <div class="col-md-6">
                <p><strong>Plan:</strong> {{ $subscription->plan->name }}</p>
                <p><strong>Status:</strong> 
                    @if($subscription->status === 'trial')
                        <span class="badge bg-info">Trial ({{ $subscription->trialDaysRemaining() }} days left)</span>
                    @else
                        <span class="badge bg-success">Active</span>
                    @endif
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>Billing Cycle:</strong> {{ ucfirst($subscription->billing_cycle) }}</p>
                @if($subscription->current_period_ends_at)
                <p><strong>Next Billing:</strong> {{ $subscription->current_period_ends_at->format('M d, Y') }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

<div class="card mb-4">
    <div class="card-header">
        <h6 class="mb-0"><i class="bi bi-rocket"></i> Quick Start Guide</h6>
    </div>
    <div class="card-body">
        <h6>Get started with these steps:</h6>
        <ol>
            <li><strong>Add Employees</strong> - Start by adding your team members</li>
            <li><strong>Set Up Departments</strong> - Organize your workforce</li>
            <li><strong>Configure Settings</strong> - Customize the system to your needs</li>
            <li><strong>Invite Users</strong> - Give your team access to the system</li>
        </ol>
    </div>
</div>

<div class="card mb-4 border-info">
    <div class="card-body">
        <h6><i class="bi bi-lightbulb"></i> Pro Tips</h6>
        <ul class="mb-0">
            <li>Check out the Reports section for insights</li>
            <li>Set up leave types and holidays</li>
            <li>Configure payroll settings</li>
            <li>Explore the training module</li>
        </ul>
    </div>
</div>

<div class="d-grid">
    <a href="{{ route('onboarding.finish') }}" class="btn btn-primary btn-lg">
        <i class="bi bi-speedometer2"></i> Go to Dashboard
    </a>
</div>

<div class="text-center mt-3">
    <small class="text-muted">
        Need help getting started? <a href="mailto:support@qayahrm.com">Contact our support team</a>
    </small>
</div>
@endsection
