<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>@yield('title') - Qaya HRM</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            padding: 20px 0;
        }
        .onboarding-container {
            max-width: 900px;
            margin: 0 auto;
        }
        .onboarding-card {
            background: white;
            border-radius: 15px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .onboarding-header {
            background: linear-gradient(135deg, #714b67 0%, #8b5a7d 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        .onboarding-body {
            padding: 40px;
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 40px;
            position: relative;
        }
        .step-indicator::before {
            content: '';
            position: absolute;
            top: 20px;
            left: 0;
            right: 0;
            height: 2px;
            background: #e0e0e0;
            z-index: 0;
        }
        .step {
            flex: 1;
            text-align: center;
            position: relative;
            z-index: 1;
        }
        .step-circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e0e0e0;
            color: #999;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 10px;
        }
        .step.active .step-circle {
            background: #714b67;
            color: white;
        }
        .step.completed .step-circle {
            background: #28a745;
            color: white;
        }
        .step-label {
            font-size: 12px;
            color: #666;
        }
        .step.active .step-label {
            color: #714b67;
            font-weight: bold;
        }
    </style>
    @stack('styles')
</head>
<body>
    <div class="container">
        <div class="onboarding-container">
            <div class="onboarding-card">
                <div class="onboarding-header">
                    <h2><i class="bi bi-building"></i> Welcome to Qaya HRM</h2>
                    <p class="mb-0">Let's get your organization set up</p>
                </div>
                
                <div class="onboarding-body">
                    @yield('content')
                </div>
            </div>

            <div class="text-center mt-3">
                <small class="text-white">
                    Need help? <a href="mailto:support@qayahrm.com" class="text-white">Contact Support</a>
                </small>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    @stack('scripts')
</body>
</html>
