@extends('layouts.app')

@section('title', 'Organization Audit Logs')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <x-page-header title="Organization Audit Logs" description="Track all organization activities">
                <x-slot:actions>
                    <a href="{{ route('organization.audit-logs.dashboard') }}" class="btn btn-info btn-sm">
                        <i class="bi bi-chart-bar"></i> Dashboard
                    </a>
                    <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#exportModal">
                        <i class="bi bi-download"></i> Export
                    </button>
                </x-slot:actions>
            </x-page-header>

            <x-alert type="success" :message="session('success')" />

            <div class="card">
                <div class="card-body">
                    <!-- Filters -->
                    <div class="row mb-3">
                        <div class="col-md-2">
                            <select class="form-select" id="userFilter">
                                <option value="">All Users</option>
                                @foreach($organizationUsers as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" id="categoryFilter">
                                <option value="">All Categories</option>
                                <option value="authentication">Authentication</option>
                                <option value="authorization">Authorization</option>
                                <option value="data_access">Data Access</option>
                                <option value="data_modification">Data Modification</option>
                                <option value="compliance">Compliance</option>
                                <option value="security">Security</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <select class="form-select" id="severityFilter">
                                <option value="">All Severities</option>
                                <option value="low">Low</option>
                                <option value="medium">Medium</option>
                                <option value="high">High</option>
                                <option value="critical">Critical</option>
                            </select>
                        </div>
                        <div class="col-md-2">
                            <input type="date" class="form-control" id="fromDate" placeholder="From Date">
                        </div>
                        <div class="col-md-2">
                            <input type="date" class="form-control" id="toDate" placeholder="To Date">
                        </div>
                        <div class="col-md-2">
                            <input type="text" class="form-control" id="searchFilter" placeholder="Search...">
                        </div>
                    </div>

                    <!-- Statistics Summary -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-info"><i class="bi bi-list"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Activities</span>
                                    <span class="info-box-number">{{ $statistics['total_activities'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-success"><i class="bi bi-users"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Active Users</span>
                                    <span class="info-box-number">{{ $organizationUsers->count() }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning"><i class="bi bi-exclamation-triangle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">High/Critical</span>
                                    <span class="info-box-number">
                                        {{ ($statistics['by_severity']['high'] ?? 0) + ($statistics['by_severity']['critical'] ?? 0) }}
                                    </span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary"><i class="bi bi-clipboard-check"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Compliance</span>
                                    <span class="info-box-number">{{ $statistics['by_category']['compliance'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Audit Logs Table -->
                    <div id="auditLogsContainer">
                        @include('organization.audit-logs.table', ['logs' => $logs])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Export Modal -->
<div class="modal fade" id="exportModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('organization.audit-logs.export') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Export Audit Logs</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Format</label>
                        <select name="format" class="form-select" required>
                            <option value="csv">CSV</option>
                            <option value="xlsx">Excel</option>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">From Date</label>
                            <input type="date" name="from_date" class="form-control">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">To Date</label>
                            <input type="date" name="to_date" class="form-control">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success">Export</button>
                </div>
            </form>
        </div>
    </div>
</div>

@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Real-time filtering
    let filterTimeout;
    
    function applyFilters() {
        clearTimeout(filterTimeout);
        filterTimeout = setTimeout(function() {
            const filters = {
                user_id: $('#userFilter').val(),
                category: $('#categoryFilter').val(),
                severity: $('#severityFilter').val(),
                from_date: $('#fromDate').val(),
                to_date: $('#toDate').val(),
                search: $('#searchFilter').val()
            };
            
            $.ajax({
                url: '{{ route("organization.audit-logs.index") }}',
                data: filters,
                success: function(response) {
                    $('#auditLogsContainer').html(response.html);
                },
                error: function() {
                    toastr.error('Failed to load audit logs');
                }
            });
        }, 500);
    }
    
    $('#userFilter, #categoryFilter, #severityFilter, #fromDate, #toDate, #searchFilter').on('change keyup', applyFilters);
});
</script>
@endpush