@extends('layouts.app')

@section('title', 'Audit Log Details')

@section('content')
<x-page-header title="Audit Log Details">
    <x-slot:breadcrumbs>
        <x-breadcrumb :items="[
            ['label' => 'Dashboard', 'url' => route('dashboard')],
            ['label' => 'Audit Logs', 'url' => route('organization.audit-logs.index')],
            ['label' => 'Log #' . $auditLog->id, 'active' => true]
        ]" />
    </x-slot:breadcrumbs>
    
    <x-slot:actions>
        <a href="{{ route('organization.audit-logs.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to Logs
        </a>
    </x-slot:actions>
</x-page-header>

<div class="row">
    <div class="col-md-6 mb-4">
        <x-info-card title="Basic Information" icon="bi-info-circle">
            <x-detail-row label="ID" :value="$auditLog->id" />
            <x-detail-row label="Date & Time" :value="$auditLog->created_at->format('Y-m-d H:i:s T')" />
            <x-detail-row label="Event Type">
                <code>{{ $auditLog->event_type }}</code>
            </x-detail-row>
            <x-detail-row label="Category">
                <x-badge :color="$auditLog->category_color">
                    {{ ucfirst(str_replace('_', ' ', $auditLog->category)) }}
                </x-badge>
            </x-detail-row>
            <x-detail-row label="Severity">
                <x-badge :color="$auditLog->severity_color">
                    {{ ucfirst($auditLog->severity) }}
                </x-badge>
            </x-detail-row>
            <x-detail-row label="Description" :value="$auditLog->description" />
        </x-info-card>
    </div>

    <div class="col-md-6 mb-4">
        <x-info-card title="User Information" icon="bi-person">
            <x-detail-row label="User">
                @if($auditLog->user)
                    <div>
                        <strong>{{ $auditLog->user->name }}</strong><br>
                        <small class="text-muted">{{ $auditLog->user->email }}</small>
                    </div>
                @else
                    <span class="text-muted">System</span>
                @endif
            </x-detail-row>
            <x-detail-row label="IP Address" :value="$auditLog->ip_address" />
            <x-detail-row label="User Agent">
                @if($auditLog->user_agent)
                    <small>{{ Str::limit($auditLog->user_agent, 100) }}</small>
                @else
                    N/A
                @endif
            </x-detail-row>
        </x-info-card>
    </div>
</div>

                    <!-- Request Information -->
                    @if($auditLog->url || $auditLog->method)
                    <div class="row mb-4">
                        <div class="col-12">
                            <x-info-card title="Request Information" icon="bi-globe">
                                @if($auditLog->url)
                                <x-detail-row label="URL">
                                    <code>{{ $auditLog->url }}</code>
                                </x-detail-row>
                                @endif
                                @if($auditLog->method)
                                <x-detail-row label="HTTP Method">
                                    <x-badge color="info">{{ $auditLog->method }}</x-badge>
                                </x-detail-row>
                                @endif
                            </x-info-card>
                        </div>
                    </div>
                    @endif

                    <!-- Entity Information -->
                    @if($auditLog->auditable_type || $auditLog->auditable_id)
                    <div class="row mb-4">
                        <div class="col-12">
                            <x-info-card title="Related Entity" icon="bi-link">
                                @if($auditLog->auditable_type)
                                <x-detail-row label="Entity Type">
                                    <code>{{ $auditLog->model_name }}</code>
                                </x-detail-row>
                                @endif
                                @if($auditLog->auditable_id)
                                <x-detail-row label="Entity ID" :value="$auditLog->auditable_id" />
                                @endif
                            </x-info-card>
                        </div>
                    </div>
                    @endif

                    <!-- Data Changes -->
                    @if($auditLog->old_values || $auditLog->new_values)
                    <div class="row mb-4">
                        <div class="col-12">
                            <x-info-card title="Data Changes" icon="bi-arrow-left-right">
                                <div class="row">
                                    @if($auditLog->old_values)
                                    <div class="col-md-6">
                                        <h6 class="text-danger">Old Values</h6>
                                        <div class="bg-light p-3 rounded">
                                            <pre class="mb-0"><code>{{ json_encode($auditLog->old_values, JSON_PRETTY_PRINT) }}</code></pre>
                                        </div>
                                    </div>
                                    @endif
                                    @if($auditLog->new_values)
                                    <div class="col-md-6">
                                        <h6 class="text-success">New Values</h6>
                                        <div class="bg-light p-3 rounded">
                                            <pre class="mb-0"><code>{{ json_encode($auditLog->new_values, JSON_PRETTY_PRINT) }}</code></pre>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </x-info-card>
                        </div>
                    </div>
                    @endif

                    <!-- Metadata -->
                    @if($auditLog->metadata)
                    <div class="row mb-4">
                        <div class="col-12">
                            <x-info-card title="Additional Metadata" icon="bi-code-square">
                                <div class="bg-light p-3 rounded">
                                    <pre class="mb-0"><code>{{ json_encode($auditLog->metadata, JSON_PRETTY_PRINT) }}</code></pre>
                                </div>
                            </x-info-card>
                        </div>
                    </div>
                    @endif

                    <!-- Related Audit Logs -->
                    @if($auditLog->user_id)
                    <div class="row">
                        <div class="col-12">
                            <x-table-card title="Recent Activities by Same User">
                                <table class="table table-sm">
                                    <thead>
                                        <tr>
                                            <th>Date</th>
                                            <th>Event</th>
                                            <th>Description</th>
                                            <th>Severity</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $relatedLogs = App\Models\AuditLog::where('user_id', $auditLog->user_id)
                                                ->forOrganization(auth()->user()->organization_id)
                                                ->where('id', '!=', $auditLog->id)
                                                ->where('created_at', '>=', $auditLog->created_at->subHours(24))
                                                ->where('created_at', '<=', $auditLog->created_at->addHours(24))
                                                ->latest()
                                                ->limit(5)
                                                ->get();
                                        @endphp
                                        @forelse($relatedLogs as $relatedLog)
                                            <tr>
                                                <td>{{ $relatedLog->created_at->format('H:i:s') }}</td>
                                                <td><code>{{ $relatedLog->event_type }}</code></td>
                                                <td>{{ Str::limit($relatedLog->description, 80) }}</td>
                                                <td>
                                                    <x-badge :color="$relatedLog->severity_color">
                                                        {{ ucfirst($relatedLog->severity) }}
                                                    </x-badge>
                                                </td>
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="4" class="text-center text-muted">No related activities found</td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </x-table-card>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection