@extends('layouts.app')

@section('title', 'Subscription Plans')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12 text-center mb-5">
            <h2>Choose Your Plan</h2>
            <p class="text-muted">Select the perfect plan for your organization</p>
        </div>
    </div>

    <div class="row justify-content-center">
        @foreach($plans as $plan)
        <div class="col-md-4 mb-4">
            <div class="card h-100 {{ $currentSubscription && $currentSubscription->subscription_plan_id == $plan->id ? 'border-primary' : '' }}">
                @if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id)
                <div class="card-header bg-primary text-white text-center">
                    <strong><i class="bi bi-check-circle"></i> Current Plan</strong>
                </div>
                @endif
                
                <div class="card-body text-center">
                    <h3 class="card-title">{{ $plan->name }}</h3>
                    <h2 class="text-primary my-4">
                        KES {{ number_format($plan->price_monthly, 0) }}
                        <small class="text-muted fs-6">/month</small>
                    </h2>
                    <p class="text-muted">{{ $plan->description }}</p>
                    
                    <hr>
                    
                    <ul class="list-unstyled text-start">
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong>{{ $plan->max_employees ?? 'Unlimited' }}</strong> Employees
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong>{{ $plan->max_users ?? 'Unlimited' }}</strong> Users
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong>{{ $plan->storage_limit_gb }} GB</strong> Storage
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            <strong>{{ count($plan->features['modules']) }}</strong> Modules
                        </li>
                        @if($plan->hasApiAccess())
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            API Access
                        </li>
                        @endif
                        @if($plan->hasFeature('white_label'))
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            White Label
                        </li>
                        @endif
                        @if($plan->hasFeature('custom_domain'))
                        <li class="mb-2">
                            <i class="bi bi-check-circle text-success"></i>
                            Custom Domain
                        </li>
                        @endif
                    </ul>
                </div>
                
                <div class="card-footer text-center">
                    @if($currentSubscription && $currentSubscription->subscription_plan_id == $plan->id)
                        <button class="btn btn-secondary" disabled>Current Plan</button>
                    @else
                        <a href="{{ route('subscription.upgrade', $plan) }}" class="btn btn-primary">
                            @if($currentSubscription)
                                @if($plan->price_monthly > $currentSubscription->plan->price_monthly)
                                    Upgrade to {{ $plan->name }}
                                @else
                                    Downgrade to {{ $plan->name }}
                                @endif
                            @else
                                Select {{ $plan->name }}
                            @endif
                        </a>
                    @endif
                </div>
            </div>
        </div>
        @endforeach
    </div>
</div>
@endsection
