@extends('layouts.app')

@section('title', 'My Subscription')

@section('content')
<x-page-header title="My Subscription">
    <x-slot:breadcrumbs>
        <x-breadcrumb :items="[
            ['label' => 'Dashboard', 'url' => route('dashboard')],
            ['label' => 'My Subscription', 'active' => true]
        ]" />
    </x-slot:breadcrumbs>
</x-page-header>

<!-- Trial Banner -->
@if($subscription->onTrial())
<x-subscription-banner 
    type="trial" 
    :daysRemaining="$subscription->trialDaysRemaining()"
    :endsAt="$subscription->trial_ends_at"
    upgradeUrl="{{ route('subscription.plans') }}" />
@endif

<!-- Cancellation Notice -->
@if($subscription->cancel_at_period_end)
<x-alert type="warning">
    <i class="bi bi-exclamation-triangle"></i>
    <strong>Subscription Scheduled for Cancellation</strong>
    <p class="mb-0">Your subscription will be cancelled on {{ $subscription->current_period_end->format('M d, Y') }}.</p>
</x-alert>
@endif

    <div class="row">
        <!-- Current Plan -->
        <div class="col-md-6 mb-4">
            <x-info-card title="Current Plan" icon="bi-star" color="primary">
                <h3>{{ $summary['plan']['name'] }}</h3>
                <h4 class="text-primary">
                    KES {{ number_format($summary['plan']['price'], 2) }}
                    <small class="text-muted">/ {{ $summary['plan']['billing_cycle'] }}</small>
                </h4>
                
                <hr>
                
                <x-detail-row label="Status">
                    <x-status-badge :status="$subscription->status" />
                </x-detail-row>
                
                @if($summary['billing']['current_period_end'])
                <x-detail-row label="Current Period Ends" :value="$summary['billing']['current_period_end']" />
                @endif
                
                @if($summary['billing']['next_billing_date'])
                <x-detail-row label="Next Billing Date" :value="$summary['billing']['next_billing_date']" />
                @endif
                
                <div class="d-grid gap-2 mt-4">
                    <a href="{{ route('subscription.plans') }}" class="btn btn-primary w-100 mb-2">
                        <i class="bi bi-arrow-up-circle"></i> Upgrade Plan
                    </a>
                    @if(!$subscription->cancel_at_period_end)
                    <a href="{{ route('subscription.cancel') }}" class="btn btn-outline-danger w-100">
                        <i class="bi bi-x-circle"></i> Cancel
                    </a>
                    @endif
                </div>
            </x-info-card>
        </div>

        <!-- Resource Usage -->
        <div class="col-md-6 mb-4">
            <x-subscription-usage :usage="$usage" />
        </div>
    </div>

    <!-- Billing Summary -->
    <div class="row">
        <div class="col-12">
            <x-info-card title="Billing Summary" icon="bi-receipt">
                <x-stats-grid>
                    <x-stat-card 
                        title="Total Paid" 
                        :value="'KES ' . number_format($billing['total_paid'], 2)" 
                        color="success" />
                    <x-stat-card 
                        title="Pending" 
                        :value="'KES ' . number_format($billing['total_pending'], 2)" 
                        color="warning" />
                    <x-stat-card 
                        title="Total Invoices" 
                        :value="$billing['invoice_count']" 
                        color="info" />
                </x-stats-grid>

                @if($billing['last_payment'])
                <div class="mt-3">
                    <strong>Last Payment:</strong>
                    KES {{ number_format($billing['last_payment']['amount'], 2) }} 
                    on {{ $billing['last_payment']['date'] }}
                    via {{ ucfirst($billing['last_payment']['method']) }}
                </div>
                @endif

                <div class="mt-3">
                    <a href="{{ route('organization.payments.history') }}" class="btn btn-outline-primary">
                        <i class="bi bi-clock-history"></i> View Payment History
                    </a>
                </div>
            </x-info-card>
        </div>
    </div>
@endsection
