@extends('layouts.app')

@section('title', 'Subscription Suspended')

@section('content')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            <div class="card border-warning">
                <div class="card-header bg-warning text-dark">
                    <h4 class="mb-0"><i class="bi bi-pause-circle"></i> Subscription Suspended</h4>
                </div>
                <div class="card-body text-center py-5">
                    <i class="bi bi-exclamation-triangle text-warning" style="font-size: 4rem;"></i>
                    <h3 class="mt-3">Your Subscription Has Been Suspended</h3>
                    <p class="lead text-muted">
                        Your subscription to <strong>{{ $subscription->plan->name }}</strong> has been temporarily suspended.
                    </p>
                    
                    <div class="alert alert-warning mt-4">
                        <h6><i class="bi bi-info-circle"></i> What This Means:</h6>
                        <ul class="text-start mb-0">
                            <li>Your access to the system has been temporarily restricted</li>
                            <li>Your data is safe and preserved</li>
                            <li>No charges will be made while suspended</li>
                            <li>Contact support to resolve this issue</li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-question-circle"></i> Why Was My Subscription Suspended?</h5>
                </div>
                <div class="card-body">
                    <p>Subscriptions are typically suspended for one of the following reasons:</p>
                    <ul>
                        <li>Multiple failed payment attempts</li>
                        <li>Terms of service violation</li>
                        <li>Account security concerns</li>
                        <li>Administrative action</li>
                    </ul>
                </div>
            </div>

            <div class="card mt-4">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-arrow-clockwise"></i> How to Reactivate</h5>
                </div>
                <div class="card-body">
                    <p>To reactivate your subscription, please:</p>
                    <ol>
                        <li>Contact our support team at <a href="mailto:support@qayahrm.com">support@qayahrm.com</a></li>
                        <li>Provide your organization details</li>
                        <li>Resolve any outstanding issues</li>
                        <li>Update payment information if needed</li>
                    </ol>
                    
                    <div class="mt-4">
                        <a href="mailto:support@qayahrm.com" class="btn btn-primary">
                            <i class="bi bi-envelope"></i> Contact Support
                        </a>
                    </div>
                </div>
            </div>

            <div class="card mt-4 border-info">
                <div class="card-body">
                    <h6><i class="bi bi-shield-check"></i> Your Data is Safe</h6>
                    <p class="mb-0">
                        All your data remains secure and will be available once your subscription is reactivated.
                        We maintain regular backups and ensure data integrity at all times.
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
