@extends('layouts.app')

@section('title', 'Upgrade Subscription')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-12">
            <h2><i class="bi bi-arrow-up-circle"></i> Upgrade Subscription</h2>
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('subscription.show') }}">Subscription</a></li>
                    <li class="breadcrumb-item active">Upgrade to {{ $plan->name }}</li>
                </ol>
            </nav>
        </div>
    </div>

    <div class="row">
        <!-- Current Plan -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header bg-secondary text-white">
                    <h5 class="mb-0"><i class="bi bi-star"></i> Current Plan</h5>
                </div>
                <div class="card-body">
                    <h3>{{ $currentSubscription->plan->name }}</h3>
                    <p class="text-muted">{{ $currentSubscription->plan->description }}</p>
                    
                    <div class="mb-3">
                        <h4 class="text-primary">
                            KES {{ number_format($currentSubscription->plan->price_monthly, 0) }}
                            <small class="text-muted">/month</small>
                        </h4>
                    </div>

                    <h6 class="mb-3">Current Features:</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-people text-primary"></i>
                            <strong>{{ $currentSubscription->plan->max_employees ?? 'Unlimited' }}</strong> Employees
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-person-check text-primary"></i>
                            <strong>{{ $currentSubscription->plan->max_users ?? 'Unlimited' }}</strong> Users
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-diagram-3 text-primary"></i>
                            <strong>{{ $currentSubscription->plan->max_departments ?? 'Unlimited' }}</strong> Departments
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-hdd text-primary"></i>
                            <strong>{{ $currentSubscription->plan->storage_limit_gb ?? 'Unlimited' }} GB</strong> Storage
                        </li>
                        @if($currentSubscription->plan->features['api_access'] ?? false)
                        <li class="mb-2">
                            <i class="bi bi-code-square text-success"></i>
                            API Access
                        </li>
                        @endif
                    </ul>

                    <div class="mt-3">
                        <span class="badge bg-secondary">Current Plan</span>
                        @if($currentSubscription->status === 'trial')
                            <span class="badge bg-info">Trial - {{ $currentSubscription->trialDaysRemaining() }} days left</span>
                        @else
                            <span class="badge bg-success">Active</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <!-- New Plan -->
        <div class="col-md-6">
            <div class="card border-primary">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-star-fill"></i> Upgrade To</h5>
                </div>
                <div class="card-body">
                    <h3>{{ $plan->name }}</h3>
                    <p class="text-muted">{{ $plan->description }}</p>
                    
                    <div class="mb-3">
                        <h4 class="text-success">
                            KES {{ number_format($plan->price_monthly, 0) }}
                            <small class="text-muted">/month</small>
                        </h4>
                        <p class="text-muted mb-0">
                            <small>
                                Increase: KES {{ number_format($plan->price_monthly - $currentSubscription->plan->price_monthly, 0) }}/month
                            </small>
                        </p>
                    </div>

                    <h6 class="mb-3">New Features:</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2">
                            <i class="bi bi-people text-success"></i>
                            <strong>{{ $plan->max_employees ?? 'Unlimited' }}</strong> Employees
                            @if(($plan->max_employees ?? PHP_INT_MAX) > ($currentSubscription->plan->max_employees ?? 0))
                                <span class="badge bg-success">+{{ ($plan->max_employees ?? 'Unlimited') - ($currentSubscription->plan->max_employees ?? 0) }}</span>
                            @endif
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-person-check text-success"></i>
                            <strong>{{ $plan->max_users ?? 'Unlimited' }}</strong> Users
                            @if(($plan->max_users ?? PHP_INT_MAX) > ($currentSubscription->plan->max_users ?? 0))
                                <span class="badge bg-success">+{{ ($plan->max_users ?? 'Unlimited') - ($currentSubscription->plan->max_users ?? 0) }}</span>
                            @endif
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-diagram-3 text-success"></i>
                            <strong>{{ $plan->max_departments ?? 'Unlimited' }}</strong> Departments
                            @if(($plan->max_departments ?? PHP_INT_MAX) > ($currentSubscription->plan->max_departments ?? 0))
                                <span class="badge bg-success">+{{ ($plan->max_departments ?? 'Unlimited') - ($currentSubscription->plan->max_departments ?? 0) }}</span>
                            @endif
                        </li>
                        <li class="mb-2">
                            <i class="bi bi-hdd text-success"></i>
                            <strong>{{ $plan->storage_limit_gb ?? 'Unlimited' }} GB</strong> Storage
                            @if(($plan->storage_limit_gb ?? PHP_INT_MAX) > ($currentSubscription->plan->storage_limit_gb ?? 0))
                                <span class="badge bg-success">+{{ ($plan->storage_limit_gb ?? 'Unlimited') - ($currentSubscription->plan->storage_limit_gb ?? 0) }} GB</span>
                            @endif
                        </li>
                        @if($plan->features['api_access'] ?? false)
                        <li class="mb-2">
                            <i class="bi bi-code-square text-success"></i>
                            API Access
                            @if(!($currentSubscription->plan->features['api_access'] ?? false))
                                <span class="badge bg-success">NEW</span>
                            @endif
                        </li>
                        @endif
                        @if($plan->features['white_label'] ?? false)
                        <li class="mb-2">
                            <i class="bi bi-palette text-success"></i>
                            White Label
                            @if(!($currentSubscription->plan->features['white_label'] ?? false))
                                <span class="badge bg-success">NEW</span>
                            @endif
                        </li>
                        @endif
                        @if($plan->features['priority_support'] ?? false)
                        <li class="mb-2">
                            <i class="bi bi-headset text-success"></i>
                            Priority Support
                            @if(!($currentSubscription->plan->features['priority_support'] ?? false))
                                <span class="badge bg-success">NEW</span>
                            @endif
                        </li>
                        @endif
                    </ul>

                    <div class="mt-3">
                        <span class="badge bg-primary">Upgrade Plan</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Upgrade Confirmation -->
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-info-circle"></i> Upgrade Details</h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-info">
                        <h6><i class="bi bi-info-circle"></i> What happens when you upgrade?</h6>
                        <ul class="mb-0">
                            <li>Your subscription will be upgraded to <strong>{{ $plan->name }}</strong> immediately</li>
                            <li>You'll get access to all new features right away</li>
                            <li>A prorated invoice will be generated for the remaining billing period</li>
                            <li>Your next billing date remains the same</li>
                            <li>You can downgrade or cancel anytime</li>
                        </ul>
                    </div>

                    @if($currentSubscription->status === 'trial')
                    <div class="alert alert-warning">
                        <h6><i class="bi bi-exclamation-triangle"></i> Trial Period</h6>
                        <p class="mb-0">
                            You are currently on a trial period with <strong>{{ $currentSubscription->trialDaysRemaining() }} days</strong> remaining.
                            Upgrading will convert your trial to a paid subscription.
                        </p>
                    </div>
                    @endif

                    <form method="POST" action="{{ route('subscription.process-upgrade', $plan) }}" id="upgrade-form">
                        @csrf
                        
                        <div class="form-check mb-3">
                            <input class="form-check-input" type="checkbox" id="confirm_upgrade" name="confirm_upgrade" required>
                            <label class="form-check-label" for="confirm_upgrade">
                                I understand that I will be charged KES {{ number_format($plan->price_monthly, 0) }}/month starting from the next billing cycle
                            </label>
                        </div>

                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-primary btn-lg" id="upgrade-button">
                                <i class="bi bi-arrow-up-circle"></i> Upgrade to {{ $plan->name }}
                            </button>
                            <a href="{{ route('subscription.show') }}" class="btn btn-outline-secondary btn-lg">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.getElementById('upgrade-form').addEventListener('submit', function(e) {
    const button = document.getElementById('upgrade-button');
    button.disabled = true;
    button.innerHTML = '<span class="spinner-border spinner-border-sm me-2"></span>Processing...';
});
</script>
@endpush
@endsection
