@extends('layouts.app')

@section('title', 'Edit Payroll Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">Edit Payroll Settings</h3>
                    <div>
                        <a href="{{ route('payroll.settings.index') }}" class="btn btn-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                        <form action="{{ route('payroll.settings.reset') }}" method="POST" class="d-inline">
                            @csrf
                            <button type="submit" class="btn btn-warning" onclick="return confirm('Are you sure you want to reset all settings to defaults?')">
                                <i class="bi bi-undo"></i> Reset to Defaults
                            </button>
                        </form>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('payroll.settings.update') }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- PAYE Settings -->
                            <div class="col-md-6">
                                <h5 class="text-primary mb-3">PAYE Tax Settings</h5>
                                
                                <div class="mb-3">
                                    <label for="personal_relief" class="form-label">Personal Relief (KES)</label>
                                    <input type="number" class="form-control @error('personal_relief') is-invalid @enderror" 
                                           id="personal_relief" name="personal_relief" 
                                           value="{{ old('personal_relief', $settings->personal_relief) }}" 
                                           step="0.01" min="0">
                                    @error('personal_relief')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="insurance_relief_rate" class="form-label">Insurance Relief Rate (%)</label>
                                    <input type="number" class="form-control @error('insurance_relief_rate') is-invalid @enderror" 
                                           id="insurance_relief_rate" name="insurance_relief_rate" 
                                           value="{{ old('insurance_relief_rate', $settings->insurance_relief_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('insurance_relief_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="insurance_relief_max" class="form-label">Insurance Relief Max (KES)</label>
                                    <input type="number" class="form-control @error('insurance_relief_max') is-invalid @enderror" 
                                           id="insurance_relief_max" name="insurance_relief_max" 
                                           value="{{ old('insurance_relief_max', $settings->insurance_relief_max) }}" 
                                           step="0.01" min="0">
                                    @error('insurance_relief_max')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="pension_relief_rate" class="form-label">Pension Relief Rate (%)</label>
                                    <input type="number" class="form-control @error('pension_relief_rate') is-invalid @enderror" 
                                           id="pension_relief_rate" name="pension_relief_rate" 
                                           value="{{ old('pension_relief_rate', $settings->pension_relief_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('pension_relief_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="pension_relief_max" class="form-label">Pension Relief Max (KES)</label>
                                    <input type="number" class="form-control @error('pension_relief_max') is-invalid @enderror" 
                                           id="pension_relief_max" name="pension_relief_max" 
                                           value="{{ old('pension_relief_max', $settings->pension_relief_max) }}" 
                                           step="0.01" min="0">
                                    @error('pension_relief_max')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Statutory Deductions -->
                            <div class="col-md-6">
                                <h5 class="text-success mb-3">Statutory Deductions</h5>
                                
                                <h6 class="text-secondary">SHIF Settings</h6>
                                <div class="mb-3">
                                    <label for="shif_rate" class="form-label">SHIF Rate (%)</label>
                                    <input type="number" class="form-control @error('shif_rate') is-invalid @enderror" 
                                           id="shif_rate" name="shif_rate" 
                                           value="{{ old('shif_rate', $settings->shif_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('shif_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="shif_min_contribution" class="form-label">SHIF Min Contribution (KES)</label>
                                    <input type="number" class="form-control @error('shif_min_contribution') is-invalid @enderror" 
                                           id="shif_min_contribution" name="shif_min_contribution" 
                                           value="{{ old('shif_min_contribution', $settings->shif_min_contribution) }}" 
                                           step="0.01" min="0">
                                    @error('shif_min_contribution')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <h6 class="text-secondary mt-4">NSSF Settings</h6>
                                <div class="mb-3">
                                    <label for="nssf_employee_rate" class="form-label">NSSF Employee Rate (%)</label>
                                    <input type="number" class="form-control @error('nssf_employee_rate') is-invalid @enderror" 
                                           id="nssf_employee_rate" name="nssf_employee_rate" 
                                           value="{{ old('nssf_employee_rate', $settings->nssf_employee_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('nssf_employee_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_employer_rate" class="form-label">NSSF Employer Rate (%)</label>
                                    <input type="number" class="form-control @error('nssf_employer_rate') is-invalid @enderror" 
                                           id="nssf_employer_rate" name="nssf_employer_rate" 
                                           value="{{ old('nssf_employer_rate', $settings->nssf_employer_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('nssf_employer_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_lower_limit" class="form-label">NSSF Lower Limit (KES)</label>
                                    <input type="number" class="form-control @error('nssf_lower_limit') is-invalid @enderror" 
                                           id="nssf_lower_limit" name="nssf_lower_limit" 
                                           value="{{ old('nssf_lower_limit', $settings->nssf_lower_limit) }}" 
                                           step="0.01" min="0">
                                    @error('nssf_lower_limit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_upper_limit" class="form-label">NSSF Upper Limit (KES)</label>
                                    <input type="number" class="form-control @error('nssf_upper_limit') is-invalid @enderror" 
                                           id="nssf_upper_limit" name="nssf_upper_limit" 
                                           value="{{ old('nssf_upper_limit', $settings->nssf_upper_limit) }}" 
                                           step="0.01" min="0">
                                    @error('nssf_upper_limit')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <!-- Housing Levy -->
                            <div class="col-md-6">
                                <h6 class="text-secondary">Housing Levy Settings</h6>
                                <div class="mb-3">
                                    <label for="housing_levy_employee_rate" class="form-label">Employee Rate (%)</label>
                                    <input type="number" class="form-control @error('housing_levy_employee_rate') is-invalid @enderror" 
                                           id="housing_levy_employee_rate" name="housing_levy_employee_rate" 
                                           value="{{ old('housing_levy_employee_rate', $settings->housing_levy_employee_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('housing_levy_employee_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="housing_levy_employer_rate" class="form-label">Employer Rate (%)</label>
                                    <input type="number" class="form-control @error('housing_levy_employer_rate') is-invalid @enderror" 
                                           id="housing_levy_employer_rate" name="housing_levy_employer_rate" 
                                           value="{{ old('housing_levy_employer_rate', $settings->housing_levy_employer_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('housing_levy_employer_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Default Allowances -->
                            <div class="col-md-6">
                                <h6 class="text-warning">Default Allowances</h6>
                                <div class="mb-3">
                                    <label for="default_house_allowance_rate" class="form-label">House Allowance Rate (%)</label>
                                    <input type="number" class="form-control @error('default_house_allowance_rate') is-invalid @enderror" 
                                           id="default_house_allowance_rate" name="default_house_allowance_rate" 
                                           value="{{ old('default_house_allowance_rate', $settings->default_house_allowance_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('default_house_allowance_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="default_transport_allowance_rate" class="form-label">Transport Allowance Rate (%)</label>
                                    <input type="number" class="form-control @error('default_transport_allowance_rate') is-invalid @enderror" 
                                           id="default_transport_allowance_rate" name="default_transport_allowance_rate" 
                                           value="{{ old('default_transport_allowance_rate', $settings->default_transport_allowance_rate * 100) }}" 
                                           step="0.01" min="0" max="100">
                                    @error('default_transport_allowance_rate')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="max_transport_allowance" class="form-label">Max Transport Allowance (KES)</label>
                                    <input type="number" class="form-control @error('max_transport_allowance') is-invalid @enderror" 
                                           id="max_transport_allowance" name="max_transport_allowance" 
                                           value="{{ old('max_transport_allowance', $settings->max_transport_allowance) }}" 
                                           step="0.01" min="0">
                                    @error('max_transport_allowance')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="default_medical_allowance" class="form-label">Default Medical Allowance (KES)</label>
                                    <input type="number" class="form-control @error('default_medical_allowance') is-invalid @enderror" 
                                           id="default_medical_allowance" name="default_medical_allowance" 
                                           value="{{ old('default_medical_allowance', $settings->default_medical_allowance) }}" 
                                           step="0.01" min="0">
                                    @error('default_medical_allowance')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <!-- Working Days -->
                            <div class="col-md-6">
                                <h6 class="text-info">Working Days Configuration</h6>
                                <div class="mb-3">
                                    <label for="default_monthly_working_days" class="form-label">Monthly Working Days</label>
                                    <input type="number" class="form-control @error('default_monthly_working_days') is-invalid @enderror" 
                                           id="default_monthly_working_days" name="default_monthly_working_days" 
                                           value="{{ old('default_monthly_working_days', $settings->default_monthly_working_days) }}" 
                                           min="1" max="31">
                                    @error('default_monthly_working_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="default_weekly_working_days" class="form-label">Weekly Working Days</label>
                                    <input type="number" class="form-control @error('default_weekly_working_days') is-invalid @enderror" 
                                           id="default_weekly_working_days" name="default_weekly_working_days" 
                                           value="{{ old('default_weekly_working_days', $settings->default_weekly_working_days) }}" 
                                           min="1" max="7">
                                    @error('default_weekly_working_days')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="default_hours_per_day" class="form-label">Hours Per Day</label>
                                    <input type="number" class="form-control @error('default_hours_per_day') is-invalid @enderror" 
                                           id="default_hours_per_day" name="default_hours_per_day" 
                                           value="{{ old('default_hours_per_day', $settings->default_hours_per_day) }}" 
                                           min="1" max="24">
                                    @error('default_hours_per_day')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>

                            <!-- Compliance Deadlines -->
                            <div class="col-md-6">
                                <h6 class="text-secondary">Compliance Deadlines</h6>
                                <div class="mb-3">
                                    <label for="kra_submission_deadline" class="form-label">KRA Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control @error('kra_submission_deadline') is-invalid @enderror" 
                                           id="kra_submission_deadline" name="kra_submission_deadline" 
                                           value="{{ old('kra_submission_deadline', $settings->kra_submission_deadline) }}" 
                                           min="1" max="31">
                                    @error('kra_submission_deadline')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="shif_submission_deadline" class="form-label">SHIF Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control @error('shif_submission_deadline') is-invalid @enderror" 
                                           id="shif_submission_deadline" name="shif_submission_deadline" 
                                           value="{{ old('shif_submission_deadline', $settings->shif_submission_deadline) }}" 
                                           min="1" max="31">
                                    @error('shif_submission_deadline')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="nssf_submission_deadline" class="form-label">NSSF Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control @error('nssf_submission_deadline') is-invalid @enderror" 
                                           id="nssf_submission_deadline" name="nssf_submission_deadline" 
                                           value="{{ old('nssf_submission_deadline', $settings->nssf_submission_deadline) }}" 
                                           min="1" max="31">
                                    @error('nssf_submission_deadline')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>

                                <div class="mb-3">
                                    <label for="housing_levy_submission_deadline" class="form-label">Housing Levy Submission Deadline (Day of Month)</label>
                                    <input type="number" class="form-control @error('housing_levy_submission_deadline') is-invalid @enderror" 
                                           id="housing_levy_submission_deadline" name="housing_levy_submission_deadline" 
                                           value="{{ old('housing_levy_submission_deadline', $settings->housing_levy_submission_deadline) }}" 
                                           min="1" max="31">
                                    @error('housing_levy_submission_deadline')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="d-flex justify-content-end">
                                    <a href="{{ route('payroll.settings.index') }}" class="btn btn-secondary me-2">Cancel</a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="bi bi-save"></i> Save Settings
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection