@extends('layouts.app')

@section('title', 'Create Performance Review')
@section('page-title', 'Create Performance Review')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">New Performance Review</h5>

                <form action="{{ route('performance.store') }}" method="POST">
                    @csrf

                    <div class="row g-3">
                        <!-- Employee & Reviewer -->
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                placeholder="Select Employee"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="reviewer_id" 
                                label="Reviewer" 
                                required
                                placeholder="Select Reviewer"
                                :options="$reviewers->pluck('full_name', 'id')->toArray()" />
                        </div>

                        <!-- Review Date & Period -->
                        <div class="col-md-6">
                            <label class="form-label">Review Date <span class="text-danger">*</span></label>
                            <input type="date" name="review_date" class="form-control @error('review_date') is-invalid @enderror"
                                   value="{{ old('review_date', date('Y-m-d')) }}" required>
                            @error('review_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Due Date</label>
                            <input type="datetime-local" name="due_date" class="form-control @error('due_date') is-invalid @enderror"
                                   value="{{ old('due_date') }}">
                            @error('due_date')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Review Period <span class="text-danger">*</span></label>
                            <select name="review_period" class="form-select @error('review_period') is-invalid @enderror" required>
                                <option value="">Select Period</option>
                                <option value="Q1" {{ old('review_period') == 'Q1' ? 'selected' : '' }}>Q1 (Jan-Mar)</option>
                                <option value="Q2" {{ old('review_period') == 'Q2' ? 'selected' : '' }}>Q2 (Apr-Jun)</option>
                                <option value="Q3" {{ old('review_period') == 'Q3' ? 'selected' : '' }}>Q3 (Jul-Sep)</option>
                                <option value="Q4" {{ old('review_period') == 'Q4' ? 'selected' : '' }}>Q4 (Oct-Dec)</option>
                                <option value="Mid-Year" {{ old('review_period') == 'Mid-Year' ? 'selected' : '' }}>Mid-Year</option>
                                <option value="Yearly" {{ old('review_period') == 'Yearly' ? 'selected' : '' }}>Yearly</option>
                            </select>
                            @error('review_period')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Review Type <span class="text-danger">*</span></label>
                            <select name="review_type" class="form-select @error('review_type') is-invalid @enderror" required>
                                <option value="">Select Type</option>
                                <option value="annual" {{ old('review_type') == 'annual' ? 'selected' : '' }}>Annual Review</option>
                                <option value="mid_year" {{ old('review_type') == 'mid_year' ? 'selected' : '' }}>Mid-Year Review</option>
                                <option value="quarterly" {{ old('review_type') == 'quarterly' ? 'selected' : '' }}>Quarterly Review</option>
                                <option value="probation" {{ old('review_type') == 'probation' ? 'selected' : '' }}>Probation Review</option>
                                <option value="project_based" {{ old('review_type') == 'project_based' ? 'selected' : '' }}>Project-Based Review</option>
                            </select>
                            @error('review_type')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Self Assessment Checkbox -->
                        <div class="col-12">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="is_self_assessment" value="1" 
                                       id="is_self_assessment" {{ old('is_self_assessment') ? 'checked' : '' }}>
                                <label class="form-check-label" for="is_self_assessment">
                                    This is a self-assessment
                                </label>
                            </div>
                        </div>

                        <!-- Performance Metrics -->
                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Performance Metrics (Rate 1-5)</h6>
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Quality of Work <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[quality_of_work]" class="form-control @error('performance_ratings.quality_of_work') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.quality_of_work') }}" required>
                            @error('performance_ratings.quality_of_work')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Productivity <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[productivity]" class="form-control @error('performance_ratings.productivity') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.productivity') }}" required>
                            @error('performance_ratings.productivity')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Communication <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[communication]" class="form-control @error('performance_ratings.communication') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.communication') }}" required>
                            @error('performance_ratings.communication')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Teamwork <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[teamwork]" class="form-control @error('performance_ratings.teamwork') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.teamwork') }}" required>
                            @error('performance_ratings.teamwork')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Initiative <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[initiative]" class="form-control @error('performance_ratings.initiative') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.initiative') }}" required>
                            @error('performance_ratings.initiative')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <label class="form-label">Attendance & Punctuality <span class="text-danger">*</span></label>
                            <input type="number" name="performance_ratings[attendance_punctuality]" class="form-control @error('performance_ratings.attendance_punctuality') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('performance_ratings.attendance_punctuality') }}" required>
                            @error('performance_ratings.attendance_punctuality')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-12">
                            <label class="form-label">Overall Rating <span class="text-danger">*</span></label>
                            <input type="number" name="overall_rating" class="form-control @error('overall_rating') is-invalid @enderror"
                                   min="1" max="5" step="0.1" value="{{ old('overall_rating') }}" required>
                            @error('overall_rating')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Comments Section -->
                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Detailed Feedback</h6>
                        </div>

                        <div class="col-12">
                            <label class="form-label">Strengths</label>
                            <textarea name="strengths" class="form-control @error('strengths') is-invalid @enderror"
                                      rows="3">{{ old('strengths') }}</textarea>
                            @error('strengths')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Areas for Improvement</label>
                            <textarea name="areas_of_improvement" class="form-control @error('areas_of_improvement') is-invalid @enderror"
                                      rows="3">{{ old('areas_of_improvement') }}</textarea>
                            @error('areas_of_improvement')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Goals for Next Period</label>
                            <textarea name="goals" class="form-control @error('goals') is-invalid @enderror"
                                      rows="3">{{ old('goals') }}</textarea>
                            @error('goals')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Manager Comments</label>
                            <textarea name="manager_comments" class="form-control @error('manager_comments') is-invalid @enderror"
                                      rows="3">{{ old('manager_comments') }}</textarea>
                            @error('manager_comments')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <label class="form-label">Additional Comments</label>
                            <textarea name="comments" class="form-control @error('comments') is-invalid @enderror"
                                      rows="3">{{ old('comments') }}</textarea>
                            @error('comments')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <!-- Action Buttons -->
                        <div class="col-12 mt-4">
                            <button type="submit" class="btn btn-primary">
                                <i class="bi bi-check-circle"></i> Create Review
                            </button>
                            <a href="{{ route('performance.index') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
