@extends('layouts.app')

@section('title', 'Edit Performance Review')
@section('page-title', 'Edit Performance Review')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">Edit Performance Review</h5>

                <form action="{{ route('performance.update', $performance) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row g-3">
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                :value="$performance->employee_id"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="reviewer_id" 
                                label="Reviewer" 
                                required
                                :value="$performance->reviewer_id"
                                :options="$reviewers->pluck('full_name', 'id')->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="date" 
                                name="review_date" 
                                label="Review Date" 
                                required
                                :value="$performance->review_date->format('Y-m-d')" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="datetime-local" 
                                name="due_date" 
                                label="Due Date"
                                :value="$performance->due_date ? $performance->due_date->format('Y-m-d\TH:i') : ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="review_period" 
                                label="Review Period" 
                                required
                                :value="$performance->review_period"
                                :options="[
                                    'Q1' => 'Q1 (Jan-Mar)',
                                    'Q2' => 'Q2 (Apr-Jun)',
                                    'Q3' => 'Q3 (Jul-Sep)',
                                    'Q4' => 'Q4 (Oct-Dec)',
                                    'Mid-Year' => 'Mid-Year',
                                    'Yearly' => 'Yearly'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="review_type" 
                                label="Review Type" 
                                required
                                :value="$performance->review_type"
                                :options="[
                                    'annual' => 'Annual Review',
                                    'mid_year' => 'Mid-Year Review',
                                    'quarterly' => 'Quarterly Review',
                                    'probation' => 'Probation Review',
                                    'project_based' => 'Project-Based Review'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="status" 
                                label="Status" 
                                required
                                :value="$performance->status"
                                :options="[
                                    'draft' => 'Draft',
                                    'submitted' => 'Submitted',
                                    'acknowledged' => 'Acknowledged',
                                    'completed' => 'Completed'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.checkbox 
                                name="is_self_assessment" 
                                label="This is a self-assessment"
                                :checked="$performance->is_self_assessment" />
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Performance Metrics (Rate 1-5)</h6>
                        </div>

                        @php
                            $ratings = old('performance_ratings', $performance->performance_ratings ?? []);
                        @endphp

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[quality_of_work]" 
                                label="Quality of Work" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['quality_of_work'] ?? ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[productivity]" 
                                label="Productivity" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['productivity'] ?? ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[communication]" 
                                label="Communication" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['communication'] ?? ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[teamwork]" 
                                label="Teamwork" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['teamwork'] ?? ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[initiative]" 
                                label="Initiative" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['initiative'] ?? ''" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="number" 
                                name="performance_ratings[attendance_punctuality]" 
                                label="Attendance & Punctuality" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$ratings['attendance_punctuality'] ?? ''" />
                        </div>

                        <div class="col-md-12">
                            <x-form.input 
                                type="number" 
                                name="overall_rating" 
                                label="Overall Rating" 
                                required
                                min="1"
                                max="5"
                                step="0.1"
                                :value="$performance->overall_rating" />
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Detailed Feedback</h6>
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="strengths" label="Strengths" rows="3" :value="$performance->strengths" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="areas_of_improvement" label="Areas for Improvement" rows="3" :value="$performance->areas_of_improvement" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="goals" label="Goals for Next Period" rows="3" :value="$performance->goals" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="manager_comments" label="Manager Comments" rows="3" :value="$performance->manager_comments" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="comments" label="Additional Comments" rows="3" :value="$performance->comments" />
                        </div>

                        <div class="col-12 mt-4">
                            <x-form.button-group 
                                cancelUrl="{{ route('performance.show', $performance) }}"
                                submitText="Update Review"
                                submitIcon="bi-check-circle" />
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
