@extends('layouts.app')

@section('title', 'Create Performance Goal')
@section('page-title', 'Create Performance Goal')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">New Performance Goal</h5>

                <form action="{{ route('performance.goals.store') }}" method="POST">
                    @csrf

                    <div class="row g-3">
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                :value="old('employee_id', $selectedEmployee?->id)"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="performance_review_id" 
                                label="Link to Performance Review"
                                :options="$performanceReviews->mapWithKeys(fn($r) => [$r->id => $r->employee->full_name . ' - ' . $r->review_period . ' ' . $r->review_date->format('Y')])->toArray()" />
                        </div>

                        <div class="col-12">
                            <x-form.input 
                                name="title" 
                                label="Goal Title" 
                                required
                                placeholder="Enter goal title" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea 
                                name="description" 
                                label="Description" 
                                required
                                rows="3"
                                placeholder="Describe the goal in detail" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="type" 
                                label="Goal Type" 
                                required
                                :options="[
                                    'individual' => 'Individual',
                                    'team' => 'Team',
                                    'company' => 'Company',
                                    'development' => 'Development',
                                    'project' => 'Project'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="priority" 
                                label="Priority" 
                                required
                                :options="[
                                    'low' => 'Low',
                                    'medium' => 'Medium',
                                    'high' => 'High',
                                    'critical' => 'Critical'
                                ]" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input type="date" name="start_date" label="Start Date" required />
                        </div>

                        <div class="col-md-6">
                            <x-form.input type="date" name="target_date" label="Target Date" required />
                        </div>

                        <div class="col-md-4">
                            <x-form.input 
                                type="number" 
                                name="weight_percentage" 
                                label="Weight (%)" 
                                required
                                min="0"
                                max="100"
                                :value="old('weight_percentage', 100)" />
                        </div>

                        <div class="col-md-4">
                            <x-form.input 
                                type="number" 
                                name="target_value" 
                                label="Target Value"
                                step="0.01"
                                min="0"
                                placeholder="e.g., 100" />
                        </div>

                        <div class="col-md-4">
                            <x-form.input 
                                name="measurement_unit" 
                                label="Measurement Unit"
                                placeholder="e.g., sales, projects, %" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea 
                                name="success_criteria" 
                                label="Success Criteria" 
                                required
                                rows="3"
                                placeholder="Define what success looks like for this goal" />
                        </div>

                        <div class="col-12">
                            <label class="form-label">Milestones</label>
                            <div id="milestones-container">
                                <div class="milestone-item border rounded p-3 mb-3">
                                    <div class="row g-2">
                                        <div class="col-md-4">
                                            <input type="text" name="milestones[0][title]" class="form-control" placeholder="Milestone title">
                                        </div>
                                        <div class="col-md-3">
                                            <input type="date" name="milestones[0][date]" class="form-control">
                                        </div>
                                        <div class="col-md-4">
                                            <input type="text" name="milestones[0][description]" class="form-control" placeholder="Description">
                                        </div>
                                        <div class="col-md-1">
                                            <button type="button" class="btn btn-outline-danger remove-milestone">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary" id="add-milestone">
                                <i class="bi bi-plus"></i> Add Milestone
                            </button>
                        </div>

                        <div class="col-12 mt-4">
                            <x-form.button-group 
                                cancelUrl="{{ route('performance.goals.index') }}"
                                submitText="Create Goal"
                                submitIcon="bi-check-circle" />
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
let milestoneIndex = 1;

document.getElementById('add-milestone').addEventListener('click', function() {
    const container = document.getElementById('milestones-container');
    const milestoneHtml = `
        <div class="milestone-item border rounded p-3 mb-3">
            <div class="row g-2">
                <div class="col-md-4">
                    <input type="text" name="milestones[${milestoneIndex}][title]" class="form-control" placeholder="Milestone title">
                </div>
                <div class="col-md-3">
                    <input type="date" name="milestones[${milestoneIndex}][date]" class="form-control">
                </div>
                <div class="col-md-4">
                    <input type="text" name="milestones[${milestoneIndex}][description]" class="form-control" placeholder="Description">
                </div>
                <div class="col-md-1">
                    <button type="button" class="btn btn-outline-danger remove-milestone">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', milestoneHtml);
    milestoneIndex++;
});

document.addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-milestone') || e.target.closest('.remove-milestone')) {
        const milestoneItem = e.target.closest('.milestone-item');
        if (document.querySelectorAll('.milestone-item').length > 1) {
            milestoneItem.remove();
        }
    }
});
</script>
@endpush
@endsection
