@extends('layouts.app')

@section('title', 'Performance Goals')
@section('page-title', 'Performance Goals')

@section('content')
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-2">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-bullseye"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Total Goals</h6>
                        <h3 class="mb-0">{{ $stats['total_goals'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-play-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Active</h6>
                        <h3 class="mb-0">{{ $stats['active_goals'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card info">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Completed</h6>
                        <h3 class="mb-0">{{ $stats['completed_goals'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-2">
            <div class="stat-card warning">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-clock"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Overdue</h6>
                        <h3 class="mb-0">{{ $stats['overdue_goals'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="stat-card secondary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-graph-up"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Average Progress</h6>
                        <h3 class="mb-0">{{ $stats['average_progress'] ?? 0 }}%</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters & Actions -->
    <div class="table-card mb-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Performance Goals</h5>
            <div class="btn-group">
                @can('create', App\Models\PerformanceGoal::class)
                <a href="{{ route('performance.goals.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> New Goal
                </a>
                @endcan
                <a href="{{ route('performance.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Reviews
                </a>
            </div>
        </div>

        <!-- Filter Form -->
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-3">
                <label class="form-label">Employee</label>
                <select name="employee" class="form-select">
                    <option value="">All Employees</option>
                    @foreach($employees as $employee)
                        <option value="{{ $employee->id }}" {{ request('employee') == $employee->id ? 'selected' : '' }}>
                            {{ $employee->full_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Type</label>
                <select name="type" class="form-select">
                    <option value="">All Types</option>
                    <option value="individual" {{ request('type') == 'individual' ? 'selected' : '' }}>Individual</option>
                    <option value="team" {{ request('type') == 'team' ? 'selected' : '' }}>Team</option>
                    <option value="company" {{ request('type') == 'company' ? 'selected' : '' }}>Company</option>
                    <option value="development" {{ request('type') == 'development' ? 'selected' : '' }}>Development</option>
                    <option value="project" {{ request('type') == 'project' ? 'selected' : '' }}>Project</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                    <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>Completed</option>
                    <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>Cancelled</option>
                    <option value="overdue" {{ request('status') == 'overdue' ? 'selected' : '' }}>Overdue</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">Priority</label>
                <select name="priority" class="form-select">
                    <option value="">All Priorities</option>
                    <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>Low</option>
                    <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>Medium</option>
                    <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>High</option>
                    <option value="critical" {{ request('priority') == 'critical' ? 'selected' : '' }}>Critical</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>

        <!-- Goals Table -->
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Goal</th>
                        <th>Employee</th>
                        <th>Type</th>
                        <th>Priority</th>
                        <th>Progress</th>
                        <th>Target Date</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($goals as $goal)
                        <tr>
                            <td>
                                <div>
                                    <div class="fw-bold">{{ $goal->title }}</div>
                                    <small class="text-muted">{{ Str::limit($goal->description, 50) }}</small>
                                </div>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($goal->employee->photo)
                                        <img src="{{ asset('storage/' . $goal->employee->photo) }}"
                                             alt="{{ $goal->employee->full_name }}"
                                             class="rounded-circle me-2"
                                             style="width: 32px; height: 32px; object-fit: cover;">
                                    @else
                                        <div class="rounded-circle me-2 bg-secondary text-white d-flex align-items-center justify-content-center"
                                             style="width: 32px; height: 32px; font-size: 14px;">
                                            {{ substr($goal->employee->first_name, 0, 1) }}{{ substr($goal->employee->last_name, 0, 1) }}
                                        </div>
                                    @endif
                                    <div>
                                        <div class="fw-bold">{{ $goal->employee->full_name }}</div>
                                        <small class="text-muted">{{ $goal->employee->employee_code }}</small>
                                    </div>
                                </div>
                            </td>
                            <td><span class="badge bg-secondary">{{ ucfirst($goal->type) }}</span></td>
                            <td><span class="badge bg-{{ $goal->priority_color }}">{{ ucfirst($goal->priority) }}</span></td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="progress me-2" style="width: 60px; height: 8px;">
                                        <div class="progress-bar" style="width: {{ $goal->progress_percentage }}%"></div>
                                    </div>
                                    <small>{{ number_format($goal->progress_percentage, 0) }}%</small>
                                </div>
                            </td>
                            <td>
                                {{ $goal->target_date->format('M d, Y') }}
                                @if($goal->isOverdue())
                                    <span class="badge bg-danger ms-1">Overdue</span>
                                @endif
                            </td>
                            <td><span class="badge bg-{{ $goal->status_color }}">{{ ucfirst($goal->status) }}</span></td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    @can('view', $goal)
                                    <a href="{{ route('performance.goals.show', $goal) }}"
                                       class="btn btn-outline-primary"
                                       title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @endcan
                                    @can('update', $goal)
                                    <a href="{{ route('performance.goals.edit', $goal) }}"
                                       class="btn btn-outline-secondary"
                                       title="Edit">
                                        <i class="bi bi-pencil"></i>
                                    </a>
                                    @endcan
                                    @can('delete', $goal)
                                    <form action="{{ route('performance.goals.destroy', $goal) }}"
                                          method="POST"
                                          class="d-inline"
                                          onsubmit="return confirm('Are you sure you want to delete this goal?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit"
                                                class="btn btn-outline-danger"
                                                title="Delete">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </form>
                                    @endcan
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="8" class="text-center py-4 text-muted">
                                <i class="bi bi-bullseye fs-1 d-block mb-2"></i>
                                No performance goals found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            {{ $goals->links() }}
        </div>
    </div>
</div>

@if(session('success'))
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast show" role="alert">
            <div class="toast-header bg-success text-white">
                <i class="bi bi-check-circle me-2"></i>
                <strong class="me-auto">Success</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">
                {{ session('success') }}
            </div>
        </div>
    </div>
@endif
@endsection