@extends('layouts.app')

@section('title', 'Create Self Assessment')
@section('page-title', 'Create Self Assessment')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">New Self Assessment</h5>

                <form action="{{ route('performance.self-assessments.store') }}" method="POST">
                    @csrf

                    <div class="row g-3">
                        @if(auth()->user()->can('create_assessments_for_others'))
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>
                        @else
                        <input type="hidden" name="employee_id" value="{{ auth()->user()->employee->id }}">
                        <div class="col-md-6">
                            <label class="form-label">Employee</label>
                            <input type="text" class="form-control" value="{{ auth()->user()->employee->full_name }}" readonly>
                        </div>
                        @endif

                        <div class="col-md-6">
                            <x-form.select 
                                name="performance_review_id" 
                                label="Link to Performance Review"
                                :options="$performanceReviews->mapWithKeys(fn($r) => [$r->id => $r->employee->full_name . ' - ' . $r->review_period . ' ' . $r->review_date->format('Y')])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input 
                                type="date" 
                                name="assessment_date" 
                                label="Assessment Date" 
                                required
                                :value="old('assessment_date', date('Y-m-d'))" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="period" 
                                label="Review Period" 
                                required
                                :options="[
                                    'Q1' => 'Q1 (Jan-Mar)',
                                    'Q2' => 'Q2 (Apr-Jun)',
                                    'Q3' => 'Q3 (Jul-Sep)',
                                    'Q4' => 'Q4 (Oct-Dec)',
                                    'Mid-Year' => 'Mid-Year',
                                    'Annual' => 'Annual'
                                ]" />
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Key Achievements</h6>
                            <label class="form-label">What are your key accomplishments during this period? <span class="text-danger">*</span></label>
                            <div id="achievements-container">
                                <div class="achievement-item mb-2">
                                    <div class="input-group">
                                        <input type="text" name="achievements[]" class="form-control @error('achievements.0') is-invalid @enderror" 
                                               placeholder="Describe a key achievement" value="{{ old('achievements.0') }}" required>
                                        <button type="button" class="btn btn-outline-danger remove-achievement">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-achievement">
                                <i class="bi bi-plus"></i> Add Achievement
                            </button>
                            @error('achievements')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Challenges & Solutions</h6>
                            <label class="form-label">What challenges did you face and how did you overcome them? <span class="text-danger">*</span></label>
                            <div id="challenges-container">
                                <div class="challenge-item mb-2">
                                    <div class="input-group">
                                        <input type="text" name="challenges_faced[]" class="form-control @error('challenges_faced.0') is-invalid @enderror" 
                                               placeholder="Describe a challenge and your solution" value="{{ old('challenges_faced.0') }}" required>
                                        <button type="button" class="btn btn-outline-danger remove-challenge">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-challenge">
                                <i class="bi bi-plus"></i> Add Challenge
                            </button>
                            @error('challenges_faced')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-md-6">
                            <x-form.textarea 
                                name="strengths_identified" 
                                label="Strengths Identified" 
                                required
                                rows="4"
                                placeholder="What are your key strengths?" />
                        </div>

                        <div class="col-md-6">
                            <x-form.textarea 
                                name="areas_for_development" 
                                label="Areas for Development" 
                                required
                                rows="4"
                                placeholder="What areas would you like to develop?" />
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Learning & Development</h6>
                            <label class="form-label">What would you like to learn or improve? <span class="text-danger">*</span></label>
                            <div id="learning-container">
                                <div class="learning-item mb-2">
                                    <div class="input-group">
                                        <input type="text" name="learning_goals[]" class="form-control @error('learning_goals.0') is-invalid @enderror" 
                                               placeholder="Describe a learning goal" value="{{ old('learning_goals.0') }}" required>
                                        <button type="button" class="btn btn-outline-danger remove-learning">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-learning">
                                <i class="bi bi-plus"></i> Add Learning Goal
                            </button>
                            @error('learning_goals')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Career Aspirations</h6>
                            <label class="form-label">What are your career goals and interests? <span class="text-danger">*</span></label>
                            <div id="career-container">
                                <div class="career-item mb-2">
                                    <div class="input-group">
                                        <input type="text" name="career_aspirations[]" class="form-control @error('career_aspirations.0') is-invalid @enderror" 
                                               placeholder="Describe a career aspiration" value="{{ old('career_aspirations.0') }}" required>
                                        <button type="button" class="btn btn-outline-danger remove-career">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-career">
                                <i class="bi bi-plus"></i> Add Career Goal
                            </button>
                            @error('career_aspirations')
                                <div class="text-danger small mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="col-12">
                            <x-form.textarea 
                                name="support_needed" 
                                label="Support Needed" 
                                required
                                rows="3"
                                placeholder="What support do you need from your manager or organization?" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="overall_satisfaction" 
                                label="Overall Job Satisfaction (1-5)" 
                                required
                                :options="[
                                    '1' => '1 - Very Dissatisfied',
                                    '2' => '2 - Dissatisfied',
                                    '3' => '3 - Neutral',
                                    '4' => '4 - Satisfied',
                                    '5' => '5 - Very Satisfied'
                                ]" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea 
                                name="additional_feedback" 
                                label="Additional Feedback"
                                rows="3"
                                placeholder="Any additional comments or feedback" />
                        </div>

                        <div class="col-12 mt-4">
                            <button type="submit" name="submit_now" value="1" class="btn btn-success">
                                <i class="bi bi-check-circle"></i> Submit Assessment
                            </button>
                            <button type="submit" name="submit_now" value="0" class="btn btn-primary">
                                <i class="bi bi-save"></i> Save as Draft
                            </button>
                            <a href="{{ route('performance.self-assessments.index') }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Dynamic field management
function setupDynamicFields(containerSelector, addButtonSelector, removeButtonClass, fieldName, placeholder) {
    let index = 1;
    
    document.getElementById(addButtonSelector.replace('#', '')).addEventListener('click', function() {
        const container = document.querySelector(containerSelector);
        const itemHtml = `
            <div class="${fieldName}-item mb-2">
                <div class="input-group">
                    <input type="text" name="${fieldName}[]" class="form-control" 
                           placeholder="${placeholder}" required>
                    <button type="button" class="btn btn-outline-danger ${removeButtonClass}">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
            </div>
        `;
        container.insertAdjacentHTML('beforeend', itemHtml);
        index++;
    });
    
    document.addEventListener('click', function(e) {
        if (e.target.classList.contains(removeButtonClass) || e.target.closest('.' + removeButtonClass)) {
            const item = e.target.closest('.' + fieldName + '-item');
            if (document.querySelectorAll('.' + fieldName + '-item').length > 1) {
                item.remove();
            }
        }
    });
}

// Setup all dynamic fields
setupDynamicFields('#achievements-container', '#add-achievement', 'remove-achievement', 'achievements', 'Describe a key achievement');
setupDynamicFields('#challenges-container', '#add-challenge', 'remove-challenge', 'challenges_faced', 'Describe a challenge and your solution');
setupDynamicFields('#learning-container', '#add-learning', 'remove-learning', 'learning_goals', 'Describe a learning goal');
setupDynamicFields('#career-container', '#add-career', 'remove-career', 'career_aspirations', 'Describe a career aspiration');
</script>
@endpush
@endsection
