@extends('layouts.app')

@section('title', 'Edit Self Assessment')
@section('page-title', 'Edit Self Assessment')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <div class="table-card">
                <h5 class="mb-4">Edit Self Assessment</h5>

                <form action="{{ route('performance.self-assessments.update', $selfAssessment) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row g-3">
                        @if(auth()->user()->can('create_assessments_for_others'))
                        <div class="col-md-6">
                            <x-form.select 
                                name="employee_id" 
                                label="Employee" 
                                required
                                :value="$selfAssessment->employee_id"
                                :options="$employees->mapWithKeys(fn($e) => [$e->id => $e->full_name . ' - ' . $e->employee_code])->toArray()" />
                        </div>
                        @else
                        <input type="hidden" name="employee_id" value="{{ $selfAssessment->employee_id }}">
                        <div class="col-md-6">
                            <label class="form-label">Employee</label>
                            <input type="text" class="form-control" value="{{ $selfAssessment->employee->full_name }}" readonly>
                        </div>
                        @endif

                        <div class="col-md-6">
                            <x-form.select 
                                name="performance_review_id" 
                                label="Link to Performance Review"
                                :value="$selfAssessment->performance_review_id"
                                :options="$performanceReviews->mapWithKeys(fn($r) => [$r->id => $r->employee->full_name . ' - ' . $r->review_period . ' ' . $r->review_date->format('Y')])->toArray()" />
                        </div>

                        <div class="col-md-6">
                            <x-form.input type="date" name="assessment_date" label="Assessment Date" required :value="$selfAssessment->assessment_date->format('Y-m-d')" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="period" 
                                label="Review Period" 
                                required
                                :value="$selfAssessment->period"
                                :options="[
                                    'Q1' => 'Q1 (Jan-Mar)',
                                    'Q2' => 'Q2 (Apr-Jun)',
                                    'Q3' => 'Q3 (Jul-Sep)',
                                    'Q4' => 'Q4 (Oct-Dec)',
                                    'Mid-Year' => 'Mid-Year',
                                    'Annual' => 'Annual'
                                ]" />
                        </div>

                        <div class="col-12 mt-4">
                            <h6 class="border-bottom pb-2 mb-3">Key Achievements</h6>
                            <label class="form-label">What are your key accomplishments during this period? <span class="text-danger">*</span></label>
                            <div id="achievements-container">
                                @foreach(old('achievements', $selfAssessment->achievements) as $index => $achievement)
                                <div class="achievement-item mb-2">
                                    <div class="input-group">
                                        <input type="text" name="achievements[]" class="form-control" 
                                               placeholder="Describe a key achievement" value="{{ $achievement }}" required>
                                        <button type="button" class="btn btn-outline-danger remove-achievement">
                                            <i class="bi bi-trash"></i>
                                        </button>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                            <button type="button" class="btn btn-outline-primary btn-sm" id="add-achievement">
                                <i class="bi bi-plus"></i> Add Achievement
                            </button>
                        </div>

                        <div class="col-md-6">
                            <x-form.textarea name="strengths_identified" label="Strengths Identified" required rows="4" :value="$selfAssessment->strengths_identified" placeholder="What are your key strengths?" />
                        </div>

                        <div class="col-md-6">
                            <x-form.textarea name="areas_for_development" label="Areas for Development" required rows="4" :value="$selfAssessment->areas_for_development" placeholder="What areas would you like to develop?" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="support_needed" label="Support Needed" required rows="3" :value="$selfAssessment->support_needed" placeholder="What support do you need from your manager or organization?" />
                        </div>

                        <div class="col-md-6">
                            <x-form.select 
                                name="overall_satisfaction" 
                                label="Overall Job Satisfaction (1-5)" 
                                required
                                :value="(string)$selfAssessment->overall_satisfaction"
                                :options="[
                                    '1' => '1 - Very Dissatisfied',
                                    '2' => '2 - Dissatisfied',
                                    '3' => '3 - Neutral',
                                    '4' => '4 - Satisfied',
                                    '5' => '5 - Very Satisfied'
                                ]" />
                        </div>

                        <div class="col-12">
                            <x-form.textarea name="additional_feedback" label="Additional Feedback" rows="3" :value="$selfAssessment->additional_feedback" placeholder="Any additional comments or feedback" />
                        </div>

                        <div class="col-12 mt-4">
                            <button type="submit" name="submit_now" value="1" class="btn btn-success">
                                <i class="bi bi-check-circle"></i> Submit Assessment
                            </button>
                            <button type="submit" name="submit_now" value="0" class="btn btn-primary">
                                <i class="bi bi-save"></i> Save as Draft
                            </button>
                            <a href="{{ route('performance.self-assessments.show', $selfAssessment) }}" class="btn btn-secondary">
                                <i class="bi bi-x-circle"></i> Cancel
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
let achievementIndex = {{ count($selfAssessment->achievements) }};

document.getElementById('add-achievement').addEventListener('click', function() {
    const container = document.getElementById('achievements-container');
    const itemHtml = `
        <div class="achievement-item mb-2">
            <div class="input-group">
                <input type="text" name="achievements[]" class="form-control" 
                       placeholder="Describe a key achievement" required>
                <button type="button" class="btn btn-outline-danger remove-achievement">
                    <i class="bi bi-trash"></i>
                </button>
            </div>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', itemHtml);
    achievementIndex++;
});

document.addEventListener('click', function(e) {
    if (e.target.classList.contains('remove-achievement') || e.target.closest('.remove-achievement')) {
        const item = e.target.closest('.achievement-item');
        if (document.querySelectorAll('.achievement-item').length > 1) {
            item.remove();
        }
    }
});
</script>
@endpush
@endsection
