@extends('layouts.app')

@section('title', 'Self Assessments')
@section('page-title', 'Self Assessments')

@section('content')
<div class="container-fluid">
    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="stat-card primary">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-person-check"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Total Assessments</h6>
                        <h3 class="mb-0">{{ $stats['total_assessments'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card success">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-check-circle"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Submitted</h6>
                        <h3 class="mb-0">{{ $stats['submitted_assessments'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card warning">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-pencil"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Drafts</h6>
                        <h3 class="mb-0">{{ $stats['draft_assessments'] }}</h3>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card info">
                <div class="d-flex align-items-center">
                    <div class="stat-icon">
                        <i class="bi bi-emoji-smile"></i>
                    </div>
                    <div class="ms-3">
                        <h6 class="text-muted mb-1">Avg Satisfaction</h6>
                        <h3 class="mb-0">{{ $stats['average_satisfaction'] ?? 0 }}/5</h3>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters & Actions -->
    <div class="table-card mb-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="mb-0">Self Assessments</h5>
            <div class="btn-group">
                @can('create', App\Models\PerformanceSelfAssessment::class)
                <a href="{{ route('performance.self-assessments.create') }}" class="btn btn-primary">
                    <i class="bi bi-plus-circle"></i> New Assessment
                </a>
                @endcan
                <a href="{{ route('performance.index') }}" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left"></i> Back to Reviews
                </a>
            </div>
        </div>

        <!-- Filter Form -->
        @if(auth()->user()->can('view_all_assessments'))
        <form method="GET" class="row g-3 mb-4">
            <div class="col-md-4">
                <label class="form-label">Employee</label>
                <select name="employee" class="form-select">
                    <option value="">All Employees</option>
                    @foreach($employees as $employee)
                        <option value="{{ $employee->id }}" {{ request('employee') == $employee->id ? 'selected' : '' }}>
                            {{ $employee->full_name }}
                        </option>
                    @endforeach
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Period</label>
                <select name="period" class="form-select">
                    <option value="">All Periods</option>
                    <option value="Q1" {{ request('period') == 'Q1' ? 'selected' : '' }}>Q1</option>
                    <option value="Q2" {{ request('period') == 'Q2' ? 'selected' : '' }}>Q2</option>
                    <option value="Q3" {{ request('period') == 'Q3' ? 'selected' : '' }}>Q3</option>
                    <option value="Q4" {{ request('period') == 'Q4' ? 'selected' : '' }}>Q4</option>
                    <option value="Mid-Year" {{ request('period') == 'Mid-Year' ? 'selected' : '' }}>Mid-Year</option>
                    <option value="Annual" {{ request('period') == 'Annual' ? 'selected' : '' }}>Annual</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="">All Status</option>
                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                    <option value="submitted" {{ request('status') == 'submitted' ? 'selected' : '' }}>Submitted</option>
                    <option value="reviewed" {{ request('status') == 'reviewed' ? 'selected' : '' }}>Reviewed</option>
                </select>
            </div>
            <div class="col-md-2">
                <label class="form-label">&nbsp;</label>
                <button type="submit" class="btn btn-primary w-100">
                    <i class="bi bi-funnel"></i> Filter
                </button>
            </div>
        </form>
        @endif

        <!-- Assessments Table -->
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        @if(auth()->user()->can('view_all_assessments'))
                        <th>Employee</th>
                        @endif
                        <th>Assessment Date</th>
                        <th>Period</th>
                        <th>Satisfaction</th>
                        <th>Status</th>
                        <th>Submitted</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($assessments as $assessment)
                        <tr>
                            @if(auth()->user()->can('view_all_assessments'))
                            <td>
                                <div class="d-flex align-items-center">
                                    @if($assessment->employee->photo)
                                        <img src="{{ asset('storage/' . $assessment->employee->photo) }}"
                                             alt="{{ $assessment->employee->full_name }}"
                                             class="rounded-circle me-2"
                                             style="width: 32px; height: 32px; object-fit: cover;">
                                    @else
                                        <div class="rounded-circle me-2 bg-secondary text-white d-flex align-items-center justify-content-center"
                                             style="width: 32px; height: 32px; font-size: 14px;">
                                            {{ substr($assessment->employee->first_name, 0, 1) }}{{ substr($assessment->employee->last_name, 0, 1) }}
                                        </div>
                                    @endif
                                    <div>
                                        <div class="fw-bold">{{ $assessment->employee->full_name }}</div>
                                        <small class="text-muted">{{ $assessment->employee->employee_code }}</small>
                                    </div>
                                </div>
                            </td>
                            @endif
                            <td>{{ $assessment->assessment_date->format('M d, Y') }}</td>
                            <td><span class="badge bg-info">{{ $assessment->period }}</span></td>
                            <td>
                                @if($assessment->overall_satisfaction)
                                    <div class="d-flex align-items-center">
                                        <span class="me-2">{{ number_format($assessment->overall_satisfaction, 1) }}</span>
                                        @for($i = 1; $i <= 5; $i++)
                                            @if($i <= $assessment->overall_satisfaction)
                                                <i class="bi bi-star-fill text-warning"></i>
                                            @else
                                                <i class="bi bi-star text-muted"></i>
                                            @endif
                                        @endfor
                                    </div>
                                @else
                                    <span class="text-muted">Not rated</span>
                                @endif
                            </td>
                            <td><span class="badge bg-{{ $assessment->status_color }}">{{ ucfirst($assessment->status) }}</span></td>
                            <td>
                                @if($assessment->submitted_at)
                                    {{ $assessment->submitted_at->format('M d, Y') }}
                                @else
                                    <span class="text-muted">Not submitted</span>
                                @endif
                            </td>
                            <td>
                                <div class="btn-group btn-group-sm">
                                    @can('view', $assessment)
                                    <a href="{{ route('performance.self-assessments.show', $assessment) }}"
                                       class="btn btn-outline-primary"
                                       title="View">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                    @endcan
                                    @if($assessment->status === 'draft')
                                        @can('update', $assessment)
                                        <a href="{{ route('performance.self-assessments.edit', $assessment) }}"
                                           class="btn btn-outline-secondary"
                                           title="Edit">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        @endcan
                                        @can('update', $assessment)
                                        <form action="{{ route('performance.self-assessments.submit', $assessment) }}"
                                              method="POST"
                                              class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to submit this assessment?');">
                                            @csrf
                                            <button type="submit"
                                                    class="btn btn-outline-success"
                                                    title="Submit">
                                                <i class="bi bi-check"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    @endif
                                    @if($assessment->status === 'draft')
                                        @can('delete', $assessment)
                                        <form action="{{ route('performance.self-assessments.destroy', $assessment) }}"
                                              method="POST"
                                              class="d-inline"
                                              onsubmit="return confirm('Are you sure you want to delete this assessment?');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit"
                                                    class="btn btn-outline-danger"
                                                    title="Delete">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                        @endcan
                                    @endif
                                </div>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="{{ auth()->user()->can('view_all_assessments') ? '7' : '6' }}" class="text-center py-4 text-muted">
                                <i class="bi bi-person-check fs-1 d-block mb-2"></i>
                                No self assessments found.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <div class="mt-3">
            {{ $assessments->links() }}
        </div>
    </div>
</div>

@if(session('success'))
    <div class="toast-container position-fixed bottom-0 end-0 p-3">
        <div class="toast show" role="alert">
            <div class="toast-header bg-success text-white">
                <i class="bi bi-check-circle me-2"></i>
                <strong class="me-auto">Success</strong>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="toast"></button>
            </div>
            <div class="toast-body">
                {{ session('success') }}
            </div>
        </div>
    </div>
@endif
@endsection