@extends('layouts.app')
@section('title', 'Self Assessment Details')
@section('page-title', 'Self Assessment Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Self Assessments', 'url' => route('performance.self-assessments.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <div>
                        <h4 class="mb-2">Self Assessment - {{ $selfAssessment->period }}</h4>
                        <p class="text-muted mb-3">{{ $selfAssessment->employee?->full_name ?? 'N/A' }} - {{ $selfAssessment->assessment_date?->format('M d, Y') ?? 'No date' }}</p>
                        <div class="d-flex gap-2 mb-3">
                            <x-status-badge :status="$selfAssessment->status" />
                            @if($selfAssessment->overall_satisfaction)
                            <span class="badge bg-info">Satisfaction: {{ number_format($selfAssessment->overall_satisfaction, 1) }}/5</span>
                            @endif
                        </div>
                    </div>
                    <div class="text-end">
                        @if($selfAssessment->status === 'draft')
                            @can('update', $selfAssessment)
                            <a href="{{ route('performance.self-assessments.edit', $selfAssessment) }}" class="btn btn-outline-primary">
                                <i class="bi bi-pencil"></i> Edit
                            </a>
                            @endcan
                        @endif
                        <a href="{{ route('performance.self-assessments.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                @if($selfAssessment->submitted_at)
                <x-alert type="info" dismissible="false">
                    Submitted on {{ $selfAssessment->submitted_at->format('M d, Y \a\t g:i A') }}
                </x-alert>
                @endif
            </x-info-card>

            @if($selfAssessment->achievements && count($selfAssessment->achievements) > 0)
            <x-info-card title="Key Achievements" icon="trophy" class="mb-4">
                <ul class="list-group list-group-flush">
                    @foreach($selfAssessment->achievements as $achievement)
                    <li class="list-group-item">{{ $achievement }}</li>
                    @endforeach
                </ul>
            </x-info-card>
            @endif

            @if($selfAssessment->challenges_faced && count($selfAssessment->challenges_faced) > 0)
            <x-info-card title="Challenges & Solutions" icon="exclamation-triangle" class="mb-4">
                <ul class="list-group list-group-flush">
                    @foreach($selfAssessment->challenges_faced as $challenge)
                    <li class="list-group-item">{{ $challenge }}</li>
                    @endforeach
                </ul>
            </x-info-card>
            @endif

            <div class="row mb-4">
                <div class="col-md-6">
                    <x-info-card title="Strengths Identified" icon="check-circle" class="h-100">
                        <p>{{ $selfAssessment->strengths_identified }}</p>
                    </x-info-card>
                </div>
                <div class="col-md-6">
                    <x-info-card title="Areas for Development" icon="arrow-up-circle" class="h-100">
                        <p>{{ $selfAssessment->areas_for_development }}</p>
                    </x-info-card>
                </div>
            </div>

            @if($selfAssessment->learning_goals && count($selfAssessment->learning_goals) > 0)
            <x-info-card title="Learning Goals" icon="book" class="mb-4">
                <ul class="list-group list-group-flush">
                    @foreach($selfAssessment->learning_goals as $goal)
                    <li class="list-group-item">{{ $goal }}</li>
                    @endforeach
                </ul>
            </x-info-card>
            @endif

            @if($selfAssessment->career_aspirations && count($selfAssessment->career_aspirations) > 0)
            <x-info-card title="Career Aspirations" icon="ladder" class="mb-4">
                <ul class="list-group list-group-flush">
                    @foreach($selfAssessment->career_aspirations as $aspiration)
                    <li class="list-group-item">{{ $aspiration }}</li>
                    @endforeach
                </ul>
            </x-info-card>
            @endif

            <x-info-card title="Support Needed" icon="hand-thumbs-up" class="mb-4">
                <p>{{ $selfAssessment->support_needed }}</p>
            </x-info-card>

            @if($selfAssessment->overall_satisfaction)
            <x-info-card title="Overall Job Satisfaction" icon="emoji-smile" class="mb-4">
                <div class="d-flex align-items-center">
                    <span class="me-3 fs-4">{{ number_format($selfAssessment->overall_satisfaction, 1) }}/5</span>
                    @for($i = 1; $i <= 5; $i++)
                        @if($i <= $selfAssessment->overall_satisfaction)
                            <i class="bi bi-star-fill text-warning fs-5"></i>
                        @else
                            <i class="bi bi-star text-muted fs-5"></i>
                        @endif
                    @endfor
                </div>
            </x-info-card>
            @endif

            @if($selfAssessment->additional_feedback)
            <x-info-card title="Additional Feedback" icon="chat-text" class="mb-4">
                <p>{{ $selfAssessment->additional_feedback }}</p>
            </x-info-card>
            @endif

            @if($selfAssessment->performanceReview)
            <x-info-card title="Linked Performance Review" icon="link">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <p class="mb-1"><strong>Review Period:</strong> {{ $selfAssessment->performanceReview->review_period }}</p>
                        <p class="mb-0"><strong>Review Date:</strong> {{ $selfAssessment->performanceReview->review_date->format('M d, Y') }}</p>
                    </div>
                    @can('view', $selfAssessment->performanceReview)
                    <a href="{{ route('performance.show', $selfAssessment->performanceReview) }}" class="btn btn-outline-primary">
                        <i class="bi bi-eye"></i> View Review
                    </a>
                    @endcan
                </div>
            </x-info-card>
            @endif
        </div>
    </div>
</div>
@endsection
