@extends('layouts.app')
@section('title', 'Performance Review Details')
@section('page-title', 'Performance Review Details')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Performance Reviews', 'url' => route('performance.index')],
    ['label' => 'Details']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-10 mx-auto">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-start mb-4">
                    <div class="d-flex align-items-center">
                        <x-user-avatar :user="$performance->employee" size="80" class="me-3" />
                        <div>
                            <h4 class="mb-1">{{ $performance->employee->full_name }}</h4>
                            <p class="mb-1 text-muted">{{ $performance->employee->employee_code }} | {{ $performance->employee->position->name ?? 'N/A' }}</p>
                            <p class="mb-0 text-muted"><i class="bi bi-diagram-3"></i> {{ $performance->employee->department->name ?? 'N/A' }}</p>
                        </div>
                    </div>
                    <div class="text-end">
                        @can('update', $performance)
                        <a href="{{ route('performance.edit', $performance) }}" class="btn btn-outline-primary">
                            <i class="bi bi-pencil"></i> Edit
                        </a>
                        @endcan
                        <a href="{{ route('performance.index') }}" class="btn btn-outline-secondary">
                            <i class="bi bi-arrow-left"></i> Back
                        </a>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <x-detail-row label="Review Date" :value="\Carbon\Carbon::parse($performance->review_date)->format('M d, Y')" />
                            <x-detail-row label="Review Period">
                                <span class="badge bg-info">{{ $performance->review_period }}</span>
                            </x-detail-row>
                            <x-detail-row label="Review Type">
                                <span class="badge bg-{{ $performance->review_type_color }}">{{ ucfirst(str_replace('_', ' ', $performance->review_type)) }}</span>
                            </x-detail-row>
                            @if($performance->is_self_assessment)
                            <x-detail-row label="Type">
                                <span class="badge bg-success">Self Assessment</span>
                            </x-detail-row>
                            @endif
                        </table>
                    </div>
                    <div class="col-md-6">
                        <table class="table table-borderless">
                            <x-detail-row label="Reviewer" :value="$performance->reviewer->full_name ?? 'N/A'" />
                            <x-detail-row label="Overall Rating">
                                <span class="fs-4 fw-bold text-primary">{{ number_format($performance->overall_rating, 1) }}/5</span>
                                @for($i = 1; $i <= 5; $i++)
                                    @if($i <= $performance->overall_rating)
                                        <i class="bi bi-star-fill text-warning"></i>
                                    @else
                                        <i class="bi bi-star text-muted"></i>
                                    @endif
                                @endfor
                            </x-detail-row>
                            @if($performance->goal_achievement_score)
                            <x-detail-row label="Goal Achievement">
                                <span class="badge bg-primary">{{ number_format($performance->goal_achievement_score, 1) }}%</span>
                            </x-detail-row>
                            @endif
                            @if($performance->due_date)
                            <x-detail-row label="Due Date" :value="$performance->due_date->format('M d, Y g:i A')" />
                            @endif
                        </table>
                    </div>
                </div>
            </x-info-card>

            <x-info-card title="Performance Metrics" class="mb-4">
                @if($performance->performance_ratings && is_array($performance->performance_ratings))
                <div class="row g-3">
                    @foreach($performance->performance_ratings as $metric => $rating)
                    <div class="col-md-6">
                        <div class="p-3 border rounded">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong>{{ ucfirst(str_replace('_', ' ', $metric)) }}</strong>
                                <span class="badge bg-primary">{{ number_format($rating, 1) }}/5</span>
                            </div>
                            <div class="progress">
                                <div class="progress-bar" style="width: {{ ($rating / 5) * 100 }}%"></div>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
                @else
                <x-alert type="info" dismissible="false">
                    No performance metrics available for this review.
                </x-alert>
                @endif
            </x-info-card>

            <x-info-card title="Detailed Feedback" class="mb-4">
                @if($performance->strengths)
                <div class="mb-4">
                    <h6 class="text-success"><i class="bi bi-check-circle"></i> Strengths</h6>
                    <p class="mb-0">{{ $performance->strengths }}</p>
                </div>
                @endif

                @if($performance->areas_of_improvement)
                <div class="mb-4">
                    <h6 class="text-warning"><i class="bi bi-exclamation-triangle"></i> Areas for Improvement</h6>
                    <p class="mb-0">{{ $performance->areas_of_improvement }}</p>
                </div>
                @endif

                @if($performance->goals)
                <div class="mb-4">
                    <h6 class="text-info"><i class="bi bi-bullseye"></i> Goals for Next Period</h6>
                    <p class="mb-0">{{ $performance->goals }}</p>
                </div>
                @endif

                @if($performance->manager_comments)
                <div class="mb-4">
                    <h6 class="text-primary"><i class="bi bi-person-badge"></i> Manager Comments</h6>
                    <p class="mb-0">{{ $performance->manager_comments }}</p>
                </div>
                @endif

                @if($performance->hr_comments)
                <div class="mb-4">
                    <h6 class="text-secondary"><i class="bi bi-people"></i> HR Comments</h6>
                    <p class="mb-0">{{ $performance->hr_comments }}</p>
                </div>
                @endif

                @if($performance->comments)
                <div class="mb-4">
                    <h6 class="text-secondary"><i class="bi bi-chat-text"></i> Additional Comments</h6>
                    <p class="mb-0">{{ $performance->comments }}</p>
                </div>
                @endif

                @if($performance->employee_comments)
                <div>
                    <h6 class="text-info"><i class="bi bi-person"></i> Employee Comments</h6>
                    <p class="mb-0">{{ $performance->employee_comments }}</p>
                </div>
                @endif
            </x-info-card>

            @if($performance->goals && $performance->goals->isNotEmpty())
            <x-info-card title="Performance Goals" icon="bullseye" class="mb-4">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Goal</th>
                                <th>Type</th>
                                <th>Progress</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($performance->goals as $goal)
                            <tr>
                                <td>
                                    <div>
                                        <div class="fw-bold">{{ $goal->title }}</div>
                                        <small class="text-muted">{{ Str::limit($goal->description, 50) }}</small>
                                    </div>
                                </td>
                                <td><span class="badge bg-secondary">{{ ucfirst($goal->type) }}</span></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="progress me-2" style="width: 60px; height: 8px;">
                                            <div class="progress-bar" style="width: {{ $goal->progress_percentage }}%"></div>
                                        </div>
                                        <small>{{ number_format($goal->progress_percentage, 0) }}%</small>
                                    </div>
                                </td>
                                <td><x-status-badge :status="$goal->status" /></td>
                                <td>
                                    @can('view', $goal)
                                    <a href="{{ route('performance.goals.show', $goal) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-eye"></i> View
                                    </a>
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-info-card>
            @endif

            @if($performance->selfAssessment)
            <x-info-card title="Self Assessment" icon="person-check" class="mb-4">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <table class="table table-borderless mb-0">
                            <x-detail-row label="Assessment Date" :value="$performance->selfAssessment->assessment_date->format('M d, Y')" />
                            <x-detail-row label="Status">
                                <x-status-badge :status="$performance->selfAssessment->status" />
                            </x-detail-row>
                            @if($performance->selfAssessment->overall_satisfaction)
                            <x-detail-row label="Job Satisfaction" :value="number_format($performance->selfAssessment->overall_satisfaction, 1) . '/5'" />
                            @endif
                        </table>
                    </div>
                    @can('view', $performance->selfAssessment)
                    <a href="{{ route('performance.self-assessments.show', $performance->selfAssessment) }}" class="btn btn-outline-primary">
                        <i class="bi bi-eye"></i> View Assessment
                    </a>
                    @endcan
                </div>
            </x-info-card>
            @endif

            @if($previousReviews->count() > 0)
            <x-info-card title="Previous Reviews">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th>Period</th>
                                <th>Overall Rating</th>
                                <th>Reviewer</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($previousReviews as $review)
                            <tr>
                                <td>{{ \Carbon\Carbon::parse($review->review_date)->format('M d, Y') }}</td>
                                <td><span class="badge bg-info">{{ $review->review_period }}</span></td>
                                <td>
                                    <strong>{{ number_format($review->overall_rating, 1) }}/5</strong>
                                    @for($i = 1; $i <= 5; $i++)
                                        @if($i <= $review->overall_rating)
                                            <i class="bi bi-star-fill text-warning small"></i>
                                        @endif
                                    @endfor
                                </td>
                                <td>{{ $review->reviewer->full_name }}</td>
                                <td>
                                    <a href="{{ route('performance.show', $review) }}" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </x-info-card>
            @endif
        </div>
    </div>
</div>
@endsection
