@extends('layouts.app')

@section('title', 'Recruitment Analytics')

@section('content')
<div class="container-fluid">
    <div class="row mb-4">
        <div class="col-md-6">
            <h2><i class="bi bi-graph-up"></i> Recruitment Analytics</h2>
        </div>
        <div class="col-md-6 text-end">
            <a href="{{ route('recruitment.analytics.export') }}" class="btn btn-success">
                <i class="bi bi-download"></i> Export Report
            </a>
        </div>
    </div>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="text-muted">Total Applications</h6>
                    <h2 class="mb-0">{{ $stats['total_applications'] }}</h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="text-muted">Active Postings</h6>
                    <h2 class="mb-0">{{ $stats['active_postings'] }}</h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="text-muted">Interviews Scheduled</h6>
                    <h2 class="mb-0">{{ $stats['interviews_scheduled'] }}</h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card shadow-sm">
                <div class="card-body">
                    <h6 class="text-muted">Offers Accepted</h6>
                    <h2 class="mb-0">{{ $stats['offers_accepted'] }}</h2>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Application Funnel -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-funnel"></i> Application Funnel</h5>
                </div>
                <div class="card-body">
                    <canvas id="funnelChart"></canvas>
                </div>
            </div>
        </div>

        <!-- Conversion Rates -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-percent"></i> Conversion Rates</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <span>Application → Interview</span>
                            <strong>{{ $conversionRates['application_to_interview'] }}%</strong>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-primary" style="width: {{ $conversionRates['application_to_interview'] }}%"></div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <span>Interview → Offer</span>
                            <strong>{{ $conversionRates['interview_to_offer'] }}%</strong>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-info" style="width: {{ $conversionRates['interview_to_offer'] }}%"></div>
                        </div>
                    </div>
                    <div class="mb-3">
                        <div class="d-flex justify-content-between mb-1">
                            <span>Offer → Hire</span>
                            <strong>{{ $conversionRates['offer_to_hire'] }}%</strong>
                        </div>
                        <div class="progress">
                            <div class="progress-bar bg-success" style="width: {{ $conversionRates['offer_to_hire'] }}%"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Time to Hire -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-clock"></i> Average Time to Hire</h5>
                </div>
                <div class="card-body text-center">
                    <h1 class="display-4 text-primary">{{ round($avgTimeToHire ?? 0) }}</h1>
                    <p class="text-muted">days</p>
                </div>
            </div>
        </div>

        <!-- Top Performing Postings -->
        <div class="col-md-6 mb-4">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-trophy"></i> Top Performing Postings</h5>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        @forelse($topPostings as $posting)
                        <div class="list-group-item d-flex justify-content-between align-items-center">
                            <span>{{ $posting->title }}</span>
                            <span class="badge bg-primary rounded-pill">{{ $posting->applications_count }} applications</span>
                        </div>
                        @empty
                        <p class="text-muted text-center py-3">No data available</p>
                        @endforelse
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Applications Over Time -->
    <div class="row">
        <div class="col-md-12">
            <div class="card shadow-sm">
                <div class="card-header">
                    <h5 class="mb-0"><i class="bi bi-graph-up-arrow"></i> Applications Over Time (Last 30 Days)</h5>
                </div>
                <div class="card-body">
                    <canvas id="timelineChart"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Funnel Chart
const funnelCtx = document.getElementById('funnelChart').getContext('2d');
new Chart(funnelCtx, {
    type: 'bar',
    data: {
        labels: ['New', 'Screening', 'Shortlisted', 'Interviewed', 'Offered'],
        datasets: [{
            label: 'Applications',
            data: [
                {{ $funnel['new'] ?? 0 }},
                {{ $funnel['screening'] ?? 0 }},
                {{ $funnel['shortlisted'] ?? 0 }},
                {{ $funnel['interviewed'] ?? 0 }},
                {{ $funnel['offered'] ?? 0 }}
            ],
            backgroundColor: ['#0d6efd', '#ffc107', '#6f42c1', '#6610f2', '#28a745']
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});

// Timeline Chart
const timelineCtx = document.getElementById('timelineChart').getContext('2d');
new Chart(timelineCtx, {
    type: 'line',
    data: {
        labels: {!! json_encode($applicationsOverTime->pluck('date')) !!},
        datasets: [{
            label: 'Applications',
            data: {!! json_encode($applicationsOverTime->pluck('count')) !!},
            borderColor: '#0d6efd',
            backgroundColor: 'rgba(13, 110, 253, 0.1)',
            fill: true,
            tension: 0.4
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        }
    }
});
</script>
@endpush
@endsection
