@extends('layouts.app')

@section('title', 'Edit Job Posting')
@section('page-title', 'Edit Job Posting')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Recruitment', 'url' => route('job-postings.index')],
        ['label' => $jobPosting->title, 'url' => route('job-postings.show', $jobPosting)],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white">
                    <h5 class="mb-0"><i class="bi bi-pencil"></i> Edit Job Posting</h5>
                </div>
                <div class="card-body">
                    @if($errors->any())
                        <x-alert type="danger">
                            <ul class="mb-0">
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-alert>
                    @endif

                    <form method="POST" action="{{ route('job-postings.update', $jobPosting) }}">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-8">
                                <x-form.input name="title" label="Job Title" required :value="$jobPosting->title" />
                            </div>
                            <div class="col-md-4">
                                <x-form.select 
                                    name="status" 
                                    label="Status" 
                                    required
                                    :value="$jobPosting->status"
                                    :options="[
                                        'draft' => 'Draft',
                                        'active' => 'Active',
                                        'closed' => 'Closed'
                                    ]" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.select 
                                    name="department_id" 
                                    label="Department" 
                                    required
                                    :value="$jobPosting->department_id"
                                    :options="$departments->pluck('name', 'id')->toArray()" />
                            </div>
                            <div class="col-md-6">
                                <x-form.select 
                                    name="position_id" 
                                    label="Position (Optional)"
                                    :value="$jobPosting->position_id"
                                    :options="$positions->pluck('name', 'id')->toArray()" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    name="location" 
                                    label="Location" 
                                    required
                                    :value="$jobPosting->location"
                                    placeholder="e.g., Nairobi, Kenya" />
                            </div>
                            <div class="col-md-6">
                                <x-form.select 
                                    name="employment_type" 
                                    label="Employment Type" 
                                    required
                                    :value="$jobPosting->employment_type"
                                    :options="[
                                        'full-time' => 'Full-time',
                                        'part-time' => 'Part-time',
                                        'contract' => 'Contract',
                                        'internship' => 'Internship'
                                    ]" />
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <x-form.input 
                                    name="salary_range" 
                                    label="Salary Range (Optional)"
                                    :value="$jobPosting->salary_range"
                                    placeholder="e.g., KES 80,000 - 120,000" />
                            </div>
                            <div class="col-md-6">
                                <x-form.input 
                                    type="date" 
                                    name="closes_at" 
                                    label="Application Deadline (Optional)"
                                    :value="$jobPosting->closes_at?->format('Y-m-d')"
                                    :min="date('Y-m-d', strtotime('+1 day'))" />
                            </div>
                        </div>

                        <x-form.textarea 
                            name="description" 
                            label="Job Description" 
                            required
                            rows="5"
                            :value="$jobPosting->description"
                            help="Describe the role, company culture, and what makes this opportunity exciting." />

                        <x-form.textarea 
                            name="requirements" 
                            label="Requirements" 
                            required
                            rows="4"
                            :value="$jobPosting->requirements"
                            help="List the required qualifications, skills, and experience." />

                        <x-form.textarea 
                            name="responsibilities" 
                            label="Key Responsibilities" 
                            required
                            rows="4"
                            :value="$jobPosting->responsibilities"
                            help="Outline the main duties and responsibilities of this role." />

                        <x-form.button-group 
                            cancelUrl="{{ route('job-postings.show', $jobPosting) }}"
                            submitText="Update Job Posting"
                            submitIcon="bi-check"
                            alignment="between" />
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
