@extends('layouts.app')

@section('title', 'Recruitment')
@section('page-title', 'Recruitment Management')

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Recruitment']
    ]" />

    <x-page-header title="Job Postings" description="Manage recruitment and job postings">
        <x-slot:actions>
            <a href="{{ route('job-postings.create') }}" class="btn btn-primary">
                <i class="bi bi-plus-circle"></i> New Job Posting
            </a>
        </x-slot:actions>
    </x-page-header>

    <x-alert type="success" :message="session('success')" />

    <!-- Statistics Cards -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-primary">{{ $stats['open_positions'] }}</h3>
                            <small class="text-muted">Open Positions</small>
                        </div>
                        <div class="text-primary">
                            <i class="bi bi-briefcase fs-2"></i>
                        </div>
                    </div>
                    <span class="badge bg-warning text-dark mt-2">Active</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-success">{{ $stats['total_applications'] }}</h3>
                            <small class="text-muted">Total Applications</small>
                        </div>
                        <div class="text-success">
                            <i class="bi bi-people fs-2"></i>
                        </div>
                    </div>
                    <span class="badge bg-success mt-2">New</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-info">{{ $stats['interviews_scheduled'] }}</h3>
                            <small class="text-muted">Interviews Scheduled</small>
                        </div>
                        <div class="text-info">
                            <i class="bi bi-calendar-event fs-2"></i>
                        </div>
                    </div>
                    <span class="badge bg-info mt-2">Pending</span>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h3 class="mb-0 text-purple">{{ $stats['offers_extended'] }}</h3>
                            <small class="text-muted">Offers Extended</small>
                        </div>
                        <div class="text-purple">
                            <i class="bi bi-award fs-2"></i>
                        </div>
                    </div>
                    <span class="badge bg-purple mt-2">MTD</span>
                </div>
            </div>
        </div>
    </div>

    <!-- Tabs -->
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <ul class="nav nav-tabs card-header-tabs" id="recruitmentTabs" role="tablist">
                <li class="nav-item" role="presentation">
                    <button class="nav-link active" id="job-postings-tab" data-bs-toggle="tab" data-bs-target="#job-postings" type="button" role="tab">
                        Job Postings
                    </button>
                </li>
                <li class="nav-item" role="presentation">
                    <button class="nav-link" id="candidates-tab" data-bs-toggle="tab" data-bs-target="#candidates" type="button" role="tab">
                        Candidates
                    </button>
                </li>
            </ul>
        </div>

        <div class="card-body">
            <div class="tab-content" id="recruitmentTabsContent">
                <!-- Job Postings Tab -->
                <div class="tab-pane fade show active" id="job-postings" role="tabpanel">
                    <!-- Filters and Actions -->
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <form method="GET" class="d-flex gap-2">
                                <input type="text" name="search" class="form-control" placeholder="Search job postings..." value="{{ request('search') }}">
                                <select name="status" class="form-select">
                                    <option value="">All Status</option>
                                    <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>Draft</option>
                                    <option value="active" {{ request('status') == 'active' ? 'selected' : '' }}>Active</option>
                                    <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>Closed</option>
                                </select>
                                <select name="department" class="form-select">
                                    <option value="">All Departments</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}" {{ request('department') == $department->id ? 'selected' : '' }}>
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                                <button type="submit" class="btn btn-outline-primary">Filter</button>
                            </form>
                        </div>
                        <div class="col-md-4 text-end">
                            @can('create_job_postings')
                                <a href="{{ route('job-postings.create') }}" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> New Job Posting
                                </a>
                            @endcan
                            @can('view_recruitment_reports')
                                <a href="{{ route('recruitment.reports.index') }}" class="btn btn-outline-info">
                                    <i class="bi bi-graph-up"></i> Reports
                                </a>
                            @endcan
                        </div>
                    </div>

                    <!-- Job Postings List -->
                    @if($jobPostings->count() > 0)
                        <div class="row">
                            @foreach($jobPostings as $jobPosting)
                                <div class="col-md-12 mb-3">
                                    <div class="card border-0 shadow-sm">
                                        <div class="card-body">
                                            <div class="row align-items-center">
                                                <div class="col-md-8">
                                                    <h5 class="card-title mb-1">{{ $jobPosting->title }}</h5>
                                                    <div class="text-muted small mb-2">
                                                        @if($jobPosting->department)
                                                        <span class="me-3">
                                                            <i class="bi bi-building"></i> {{ $jobPosting->department->name }}
                                                        </span>
                                                        @endif
                                                        <span class="me-3">
                                                            <i class="bi bi-geo-alt"></i> {{ $jobPosting->location }}
                                                        </span>
                                                        <span class="me-3">
                                                            <i class="bi bi-clock"></i> {{ ucfirst($jobPosting->employment_type) }}
                                                        </span>
                                                    </div>
                                                    <div class="d-flex align-items-center gap-2">
                                                        <span class="text-muted small">
                                                            <i class="bi bi-people"></i> {{ $jobPosting->applications_count }} applications
                                                        </span>
                                                        <span class="text-muted small">
                                                            <i class="bi bi-calendar"></i> Posted {{ $jobPosting->created_at->diffForHumans() }}
                                                        </span>
                                                    </div>
                                                </div>
                                                <div class="col-md-4 text-end">
                                                    <div class="mb-2">
                                                        @if($jobPosting->status === 'active')
                                                            <span class="badge bg-success">Active</span>
                                                        @elseif($jobPosting->status === 'draft')
                                                            <span class="badge bg-secondary">Draft</span>
                                                        @else
                                                            <span class="badge bg-danger">Closed</span>
                                                        @endif
                                                    </div>
                                                    <a href="{{ route('job-postings.show', $jobPosting) }}" class="btn btn-outline-primary btn-sm">
                                                        <i class="bi bi-eye"></i> View
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $jobPostings->links() }}
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-briefcase fs-1 text-muted"></i>
                            <h5 class="text-muted mt-2">No job postings found</h5>
                            <p class="text-muted">Create your first job posting to start recruiting.</p>
                            @can('create_job_postings')
                                <a href="{{ route('job-postings.create') }}" class="btn btn-primary">
                                    <i class="bi bi-plus"></i> Create Job Posting
                                </a>
                            @endcan
                        </div>
                    @endif
                </div>

                <!-- Candidates Tab -->
                <div class="tab-pane fade" id="candidates" role="tabpanel">
                    <div class="text-center py-5">
                        <i class="bi bi-people fs-1 text-muted"></i>
                        <h5 class="text-muted mt-2">Candidates Management</h5>
                        <p class="text-muted">This feature will be available in the next update.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('styles')
<style>
.text-purple {
    color: #6f42c1 !important;
}
.bg-purple {
    background-color: #6f42c1 !important;
}
</style>
@endpush