<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Job Offer - {{ $offer->position_title }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 40px;
        }
        .header {
            text-align: center;
            margin-bottom: 40px;
            padding-bottom: 20px;
            border-bottom: 2px solid #0d6efd;
        }
        .company-name {
            font-size: 24pt;
            font-weight: bold;
            color: #0d6efd;
            margin-bottom: 10px;
        }
        .document-title {
            font-size: 18pt;
            font-weight: bold;
            margin-top: 20px;
            color: #333;
        }
        .date {
            font-size: 10pt;
            color: #666;
            margin-top: 10px;
        }
        .content {
            margin-top: 30px;
        }
        .section {
            margin-bottom: 25px;
        }
        .section-title {
            font-size: 13pt;
            font-weight: bold;
            color: #0d6efd;
            margin-bottom: 10px;
            padding-bottom: 5px;
            border-bottom: 1px solid #ddd;
        }
        .candidate-info {
            margin-bottom: 30px;
        }
        .info-row {
            margin-bottom: 8px;
        }
        .label {
            font-weight: bold;
            display: inline-block;
            width: 150px;
        }
        .value {
            display: inline-block;
        }
        .offer-details {
            background-color: #f8f9fa;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .benefits-list {
            margin-left: 20px;
            margin-top: 10px;
        }
        .benefits-list li {
            margin-bottom: 5px;
        }
        .terms {
            font-size: 10pt;
            line-height: 1.5;
            margin-top: 20px;
            padding: 15px;
            background-color: #fff9e6;
            border-left: 3px solid #ffc107;
        }
        .signature-section {
            margin-top: 50px;
            page-break-inside: avoid;
        }
        .signature-line {
            margin-top: 60px;
            border-top: 1px solid #333;
            width: 300px;
            padding-top: 10px;
        }
        .footer {
            margin-top: 50px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            font-size: 9pt;
            color: #666;
            text-align: center;
        }
        .expiry-notice {
            background-color: #fff3cd;
            border: 1px solid #ffc107;
            padding: 15px;
            margin: 20px 0;
            border-radius: 5px;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="company-name">{{ $offer->organization->name ?? 'Company Name' }}</div>
        @if($offer->organization->address)
        <div style="font-size: 10pt; color: #666;">{{ $offer->organization->address }}</div>
        @endif
        @if($offer->organization->email)
        <div style="font-size: 10pt; color: #666;">{{ $offer->organization->email }}</div>
        @endif
        <div class="document-title">EMPLOYMENT OFFER LETTER</div>
        <div class="date">{{ now()->format('F d, Y') }}</div>
    </div>

    <div class="content">
        <div class="candidate-info">
            <div class="info-row">
                <span class="label">Candidate Name:</span>
                <span class="value">{{ $offer->application->full_name }}</span>
            </div>
            <div class="info-row">
                <span class="label">Email:</span>
                <span class="value">{{ $offer->application->email }}</span>
            </div>
            <div class="info-row">
                <span class="label">Phone:</span>
                <span class="value">{{ $offer->application->phone }}</span>
            </div>
        </div>

        <div class="section">
            <p>Dear {{ $offer->application->full_name }},</p>
            
            <p>We are pleased to offer you the position of <strong>{{ $offer->position_title }}</strong> at {{ $offer->organization->name ?? 'our organization' }}. We were impressed with your qualifications and believe you will be a valuable addition to our team.</p>
        </div>

        <div class="offer-details">
            <div class="section-title">Position Details</div>
            
            <div class="info-row">
                <span class="label">Position:</span>
                <span class="value">{{ $offer->position_title }}</span>
            </div>
            
            <div class="info-row">
                <span class="label">Compensation:</span>
                <span class="value">{{ $offer->organization->currency ?? '$' }} {{ number_format($offer->salary, 2) }} per {{ $offer->salary_period }}</span>
            </div>
            
            <div class="info-row">
                <span class="label">Start Date:</span>
                <span class="value">{{ $offer->start_date->format('F d, Y') }}</span>
            </div>
        </div>

        @if($offer->benefits)
        <div class="section">
            <div class="section-title">Benefits & Perks</div>
            <div style="white-space: pre-line;">{{ $offer->benefits }}</div>
        </div>
        @endif

        @if($offer->terms_and_conditions)
        <div class="section">
            <div class="section-title">Terms & Conditions</div>
            <div class="terms">
                <div style="white-space: pre-line;">{{ $offer->terms_and_conditions }}</div>
            </div>
        </div>
        @endif

        @if($offer->expires_at)
        <div class="expiry-notice">
            <strong>Important:</strong> This offer is valid until {{ $offer->expires_at->format('F d, Y') }}. Please respond before this date.
        </div>
        @endif

        <div class="section">
            <p>To accept this offer, please visit the following link:</p>
            <p><strong>{{ $offer->offer_url }}</strong></p>
            <p>If you have any questions about this offer, please don't hesitate to contact us.</p>
        </div>

        <div class="section">
            <p>We look forward to welcoming you to our team!</p>
            <p>Sincerely,</p>
        </div>

        <div class="signature-section">
            <div class="signature-line">
                <div>{{ $offer->creator->name ?? 'HR Department' }}</div>
                <div style="font-size: 10pt; color: #666;">{{ $offer->organization->name ?? 'Company Name' }}</div>
            </div>
        </div>
    </div>

    <div class="footer">
        <p>This is a confidential document. Please do not share with unauthorized parties.</p>
        <p>Generated on {{ now()->format('F d, Y \a\t h:i A') }}</p>
    </div>
</body>
</html>
