@extends('layouts.app')
@section('title', 'Job Offer')
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Job Posting', 'url' => route('job-postings.show', $jobOffer->application->job_posting_id)],
    ['label' => 'Job Offer']
]" />

<div class="container-fluid">
    <div class="row">
        <div class="col-md-8">
            <x-info-card>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h5 class="mb-0"><i class="bi bi-file-earmark-text"></i> Job Offer</h5>
                    <x-status-badge :status="$jobOffer->status" />
                </div>

                <h4 class="mb-3">{{ $jobOffer->position_title }}</h4>

                <div class="row">
                    <div class="col-md-6 mb-3">
                        <h6 class="text-muted">Salary</h6>
                        <p class="mb-0"><strong class="text-success">{{ $jobOffer->formatted_salary }}</strong></p>
                    </div>
                    <div class="col-md-6 mb-3">
                        <h6 class="text-muted">Start Date</h6>
                        <p class="mb-0">{{ $jobOffer->start_date->format('F j, Y') }}</p>
                    </div>
                </div>

                @if($jobOffer->benefits)
                <div class="mt-3">
                    <h6 class="text-muted">Benefits</h6>
                    <p style="white-space: pre-line;">{{ $jobOffer->benefits }}</p>
                </div>
                @endif

                <div class="mt-3">
                    <h6 class="text-muted">Terms & Conditions</h6>
                    <p style="white-space: pre-line;">{{ $jobOffer->terms_and_conditions }}</p>
                </div>

                @if($jobOffer->status === 'sent')
                <x-alert type="info" dismissible="false" class="mt-4">
                    Offer sent on {{ $jobOffer->sent_at->format('F j, Y') }}
                    @if($jobOffer->expires_at)
                    · Expires {{ $jobOffer->expires_at->format('F j, Y') }}
                    @endif
                </x-alert>
                @endif

                @if($jobOffer->status === 'accepted')
                <x-alert type="success" dismissible="false" class="mt-4">
                    Offer accepted on {{ $jobOffer->responded_at->format('F j, Y') }}
                </x-alert>
                @endif

                @if($jobOffer->status === 'declined')
                <x-alert type="danger" dismissible="false" class="mt-4">
                    Offer declined on {{ $jobOffer->responded_at->format('F j, Y') }}
                    @if($jobOffer->candidate_notes)
                    <p class="mb-0 mt-2"><strong>Reason:</strong> {{ $jobOffer->candidate_notes }}</p>
                    @endif
                </x-alert>
                @endif

                <div class="mt-4">
                    @if($jobOffer->status === 'draft')
                    <a href="{{ route('job-offers.edit', $jobOffer) }}" class="btn btn-primary">
                        <i class="bi bi-pencil"></i> Edit Offer
                    </a>
                    <button type="button" class="btn btn-success" data-bs-toggle="modal" data-bs-target="#sendModal">
                        <i class="bi bi-send"></i> Send Offer
                    </button>
                    @endif

                    @if($jobOffer->status === 'sent')
                    <a href="{{ route('offer.view', $jobOffer->offer_token) }}" class="btn btn-outline-primary" target="_blank">
                        <i class="bi bi-eye"></i> View Candidate Link
                    </a>
                    @endif
                </div>
            </x-info-card>
        </div>

        <div class="col-md-4">
            <x-info-card title="Candidate Info" icon="person">
                <table class="table table-borderless">
                    <x-detail-row label="Name" :value="$jobOffer->application->full_name" />
                    <x-detail-row label="Email" :value="$jobOffer->application->email" />
                    <x-detail-row label="Phone" :value="$jobOffer->application->phone" />
                    <x-detail-row label="Applied" :value="$jobOffer->application->applied_at->format('M d, Y')" />
                </table>
            </x-info-card>
        </div>
    </div>
</div>

<x-modal id="sendModal" title="Send Job Offer">
    <form method="POST" action="{{ route('job-offers.send', $jobOffer) }}">
        @csrf
        <div class="modal-body">
            <p>Are you sure you want to send this offer to <strong>{{ $jobOffer->application->full_name }}</strong>?</p>
            <p class="text-muted small">The candidate will receive an email with a link to view and respond to the offer.</p>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
            <button type="submit" class="btn btn-success">Send Offer</button>
        </div>
    </form>
</x-modal>
@endsection
