<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Already Applied - {{ $jobPosting->organization->name }}</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-sm">
                    <div class="card-body text-center py-5">
                        <div class="text-info mb-4">
                            <i class="bi bi-check-circle-fill" style="font-size: 4rem;"></i>
                        </div>
                        
                        <h2 class="text-info mb-3">You've Already Applied!</h2>
                        
                        <p class="text-muted mb-4">
                            You have already submitted an application for the <strong>{{ $jobPosting->title }}</strong> position at {{ $jobPosting->organization->name }}.
                        </p>

                        <div class="bg-light p-3 rounded mb-4">
                            <h6 class="mb-2">Your Application Details:</h6>
                            <div class="row text-start">
                                <div class="col-sm-6">
                                    <small class="text-muted">Applicant:</small><br>
                                    <strong>{{ $existingApplication->full_name }}</strong>
                                </div>
                                <div class="col-sm-6">
                                    <small class="text-muted">Email:</small><br>
                                    <strong>{{ $existingApplication->email }}</strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Applied On:</small><br>
                                    <strong>{{ $existingApplication->applied_at->format('M d, Y H:i') }}</strong>
                                </div>
                                <div class="col-sm-6 mt-2">
                                    <small class="text-muted">Status:</small><br>
                                    @switch($existingApplication->status)
                                        @case('new')
                                            <span class="badge bg-primary">New</span>
                                            @break
                                        @case('screening')
                                            <span class="badge bg-warning">Under Review</span>
                                            @break
                                        @case('shortlisted')
                                            <span class="badge bg-info">Shortlisted</span>
                                            @break
                                        @case('interviewed')
                                            <span class="badge bg-secondary">Interviewed</span>
                                            @break
                                        @case('offered')
                                            <span class="badge bg-success">Offer Extended</span>
                                            @break
                                        @case('rejected')
                                            <span class="badge bg-danger">Not Selected</span>
                                            @break
                                        @default
                                            <span class="badge bg-secondary">{{ ucfirst($existingApplication->status) }}</span>
                                    @endswitch
                                    @if($existingApplication->updated_count > 0)
                                        <br><small class="text-muted">Updated {{ $existingApplication->updated_count }} time(s)</small>
                                    @endif
                                </div>
                            </div>
                        </div>

                        @if($existingApplication->status === 'new')
                            <div class="alert alert-info">
                                <i class="bi bi-clock"></i>
                                <strong>Good news!</strong> Your application is being reviewed by our HR team. 
                                We'll contact you if you're selected for the next stage.
                            </div>
                        @elseif($existingApplication->status === 'screening')
                            <div class="alert alert-warning">
                                <i class="bi bi-search"></i>
                                <strong>Under Review!</strong> Your application is currently being screened by our team.
                            </div>
                        @elseif($existingApplication->status === 'shortlisted')
                            <div class="alert alert-success">
                                <i class="bi bi-star"></i>
                                <strong>Congratulations!</strong> You've been shortlisted. We'll contact you soon for the next steps.
                            </div>
                        @elseif($existingApplication->status === 'offered')
                            <div class="alert alert-success">
                                <i class="bi bi-trophy"></i>
                                <strong>Offer Extended!</strong> Congratulations! Please check your email for offer details.
                            </div>
                        @else
                            <div class="alert alert-secondary">
                                <i class="bi bi-info-circle"></i>
                                Your application has been processed. Thank you for your interest in this position.
                            </div>
                        @endif

                        <div class="mt-4">
                            <p class="text-muted mb-3">
                                <strong>Looking for other opportunities?</strong><br>
                                Check out our other open positions or visit our careers page.
                            </p>
                            
                            @php
                                $websiteUrl = $jobPosting->organization->website ?? config('app.url');
                            @endphp
                            
                            <a href="{{ $websiteUrl }}" class="btn btn-primary me-2">
                                <i class="bi bi-globe"></i> Visit Our Website
                            </a>
                            
                            <button onclick="window.print()" class="btn btn-outline-secondary">
                                <i class="bi bi-printer"></i> Print Details
                            </button>
                        </div>
                    </div>
                </div>

                <div class="text-center mt-4">
                    <p class="text-muted small">
                        <i class="bi bi-building"></i>
                        {{ $jobPosting->organization->name }} - Human Resources
                    </p>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>