@extends('layouts.app')

@section('title', 'Detailed Recruitment Report')
@section('page-title', 'Detailed Recruitment Report')

@section('content')
    <div class="mb-4">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                <li class="breadcrumb-item"><a href="{{ route('job-postings.index') }}">Recruitment</a></li>
                <li class="breadcrumb-item"><a href="{{ route('recruitment.reports.index') }}">Reports</a></li>
                <li class="breadcrumb-item active">Detailed Report</li>
            </ol>
        </nav>
    </div>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-header bg-white">
            <h5 class="mb-0">Report Filters</h5>
        </div>
        <div class="card-body">
            <form method="GET" class="row">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" class="form-control" value="{{ $startDate }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" class="form-control" value="{{ $endDate }}">
                </div>
                <div class="col-md-3">
                    <label class="form-label">Department</label>
                    <select name="department" class="form-select">
                        <option value="">All Departments</option>
                        @foreach($departments as $dept)
                            <option value="{{ $dept->id }}" {{ $department == $dept->id ? 'selected' : '' }}>
                                {{ $dept->name }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Job Posting</label>
                    <select name="job_posting" class="form-select">
                        <option value="">All Job Postings</option>
                        @foreach($jobPostings as $job)
                            <option value="{{ $job->id }}" {{ $jobPosting == $job->id ? 'selected' : '' }}>
                                {{ $job->title }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-12 mt-3">
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-funnel"></i> Apply Filters
                    </button>
                    <a href="{{ route('recruitment.reports.export') }}?{{ http_build_query(request()->all()) }}&format=csv" class="btn btn-success">
                        <i class="bi bi-download"></i> Export Filtered Data
                    </a>
                </div>
            </form>
        </div>
    </div>

    <!-- Summary Statistics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-primary">{{ $summary['total_applications'] }}</h3>
                    <small class="text-muted">Total Applications</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-success">{{ $summary['status_breakdown']['offered'] ?? 0 }}</h3>
                    <small class="text-muted">Offers Extended</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-warning">{{ $summary['avg_processing_time'] }}</h3>
                    <small class="text-muted">Avg. Processing Time (days)</small>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card border-0 shadow-sm">
                <div class="card-body text-center">
                    <h3 class="mb-0 text-info">
                        {{ $summary['total_applications'] > 0 ? round((($summary['status_breakdown']['offered'] ?? 0) / $summary['total_applications']) * 100, 1) : 0 }}%
                    </h3>
                    <small class="text-muted">Success Rate</small>
                </div>
            </div>
        </div>
    </div>

    <!-- Applications Table -->
    <div class="card shadow-sm">
        <div class="card-header bg-white">
            <h5 class="mb-0">Applications ({{ $applications->total() }} total)</h5>
        </div>
        <div class="card-body">
            @if($applications->count() > 0)
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Application ID</th>
                                <th>Applicant</th>
                                <th>Contact</th>
                                <th>Position</th>
                                <th>Department</th>
                                <th>Status</th>
                                <th>Applied Date</th>
                                <th>Last Updated</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($applications as $application)
                                <tr>
                                    <td>
                                        <code>{{ $application->tracking_token }}</code>
                                    </td>
                                    <td>
                                        <strong>{{ $application->full_name }}</strong>
                                    </td>
                                    <td>
                                        <div>{{ $application->email }}</div>
                                        <small class="text-muted">{{ $application->phone }}</small>
                                    </td>
                                    <td>{{ $application->jobPosting->title }}</td>
                                    <td>{{ $application->jobPosting->department->name ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge bg-{{ 
                                            $application->status === 'new' ? 'primary' : 
                                            ($application->status === 'screening' ? 'warning' : 
                                            ($application->status === 'shortlisted' ? 'info' : 
                                            ($application->status === 'interviewed' ? 'secondary' : 
                                            ($application->status === 'offered' ? 'success' : 'danger')))) 
                                        }}">
                                            {{ ucfirst($application->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $application->applied_at->format('M d, Y') }}</td>
                                    <td>{{ $application->updated_at->format('M d, Y') }}</td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            @if($application->cv_path)
                                                <a href="{{ route('applications.cv.view', $application) }}" 
                                                   class="btn btn-outline-primary" target="_blank" title="View CV">
                                                    <i class="bi bi-eye"></i>
                                                </a>
                                                <a href="{{ route('applications.cv.download', $application) }}" 
                                                   class="btn btn-outline-success" title="Download CV">
                                                    <i class="bi bi-download"></i>
                                                </a>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="d-flex justify-content-center mt-4">
                    {{ $applications->appends(request()->query())->links() }}
                </div>
            @else
                <div class="text-center py-5">
                    <i class="bi bi-inbox fs-1 text-muted"></i>
                    <h5 class="text-muted mt-2">No applications found</h5>
                    <p class="text-muted">Try adjusting your filters to see more results.</p>
                </div>
            @endif
        </div>
    </div>
@endsection

@push('scripts')
<script>
    // Auto-submit form when department changes to update job postings
    document.querySelector('select[name="department"]').addEventListener('change', function() {
        // You could add AJAX here to update job postings dropdown
        // For now, we'll just submit the form
    });
</script>
@endpush