@extends('layouts.app')

@section('title', 'Training Reports')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Training Reports</h1>
                <div>
                    <a href="{{ route('reports.export-training-pdf', request()->query()) }}" class="btn btn-outline-danger me-2">
                        <i class="bi bi-file-pdf"></i> Export PDF
                    </a>
                    <a href="{{ route('reports.index') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Reports
                    </a>
                </div>
            </div>

            <!-- Filters -->
            <div class="card mb-4">
                <div class="card-body">
                    <form method="GET" action="{{ route('reports.training') }}">
                        <div class="row">
                            <div class="col-md-3">
                                <label for="start_date" class="form-label">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ $startDate }}">
                            </div>
                            <div class="col-md-3">
                                <label for="end_date" class="form-label">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ $endDate }}">
                            </div>
                            <div class="col-md-2">
                                <label for="category" class="form-label">Category</label>
                                <select class="form-select" id="category" name="category">
                                    <option value="">All Categories</option>
                                    @foreach($categories as $category)
                                        <option value="{{ $category->id }}" {{ request('category') == $category->id ? 'selected' : '' }}>
                                            {{ $category->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="department" class="form-label">Department</label>
                                <select class="form-select" id="department" name="department">
                                    <option value="">All Departments</option>
                                    @foreach($departments as $department)
                                        <option value="{{ $department->id }}" {{ request('department') == $department->id ? 'selected' : '' }}>
                                            {{ $department->name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label for="program" class="form-label">Program</label>
                                <select class="form-select" id="program" name="program">
                                    <option value="">All Programs</option>
                                    @foreach($programs as $program)
                                        <option value="{{ $program->id }}" {{ request('program') == $program->id ? 'selected' : '' }}>
                                            {{ Str::limit($program->title, 30) }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="row mt-3">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-filter"></i> Apply Filters
                                </button>
                                <a href="{{ route('reports.training') }}" class="btn btn-outline-secondary">
                                    <i class="bi bi-x-circle"></i> Clear Filters
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Summary Statistics -->
            <div class="row mb-4">
                <div class="col-md-3">
                    <div class="card bg-primary text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $summary['total_sessions'] }}</h4>
                                    <p class="mb-0">Total Sessions</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-calendar-alt fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-success text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $summary['total_enrollments'] }}</h4>
                                    <p class="mb-0">Total Enrollments</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-users fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-info text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $summary['completion_rate'] }}%</h4>
                                    <p class="mb-0">Completion Rate</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-chart-line fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="card bg-warning text-white">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h4 class="mb-0">{{ $summary['unique_participants'] }}</h4>
                                    <p class="mb-0">Unique Participants</p>
                                </div>
                                <div class="align-self-center">
                                    <i class="bi bi-user-graduate fa-2x"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Additional Statistics -->
            <div class="row mb-4">
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body text-center">
                            <h5 class="text-success">{{ $summary['attended_enrollments'] }}</h5>
                            <p class="text-muted mb-0">Attended Sessions</p>
                            <small class="text-success">{{ $summary['attendance_rate'] }}% attendance rate</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body text-center">
                            <h5 class="text-danger">{{ $summary['no_show_enrollments'] }}</h5>
                            <p class="text-muted mb-0">No Shows</p>
                            <small class="text-danger">{{ $summary['no_show_rate'] }}% no-show rate</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-body text-center">
                            <h5 class="text-info">{{ number_format($summary['total_training_hours'], 1) }}</h5>
                            <p class="text-muted mb-0">Total Training Hours</p>
                            <small class="text-info">Delivered to participants</small>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mb-4">
                <!-- Category Breakdown -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Training by Category</h5>
                        </div>
                        <div class="card-body">
                            @if($categoryBreakdown->count() > 0)
                                @foreach($categoryBreakdown as $category)
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div>
                                            <strong>{{ $category['name'] }}</strong><br>
                                            <small class="text-muted">{{ $category['total_enrollments'] }} enrollments</small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-success">{{ $category['completion_rate'] }}% completed</span><br>
                                            <small class="text-muted">{{ $category['attendance_rate'] }}% attended</small>
                                        </div>
                                    </div>
                                    <div class="progress mb-3" style="height: 6px;">
                                        <div class="progress-bar bg-success" style="width: {{ $category['completion_rate'] }}%"></div>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-chart-pie fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No category data available</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>

                <!-- Department Breakdown -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Training by Department</h5>
                        </div>
                        <div class="card-body">
                            @if($departmentBreakdown->count() > 0)
                                @foreach($departmentBreakdown->take(8) as $department)
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div>
                                            <strong>{{ $department['name'] }}</strong><br>
                                            <small class="text-muted">{{ $department['unique_employees'] }} employees, {{ $department['total_enrollments'] }} enrollments</small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-info">{{ $department['completion_rate'] }}% completed</span><br>
                                            <small class="text-muted">{{ $department['attendance_rate'] }}% attended</small>
                                        </div>
                                    </div>
                                    <div class="progress mb-3" style="height: 6px;">
                                        <div class="progress-bar bg-info" style="width: {{ $department['completion_rate'] }}%"></div>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-building fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No department data available</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Cost Analysis -->
            <div class="row mb-4">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Cost Analysis</h5>
                        </div>
                        <div class="card-body">
                            <div class="row text-center">
                                <div class="col-6">
                                    <h4 class="text-primary">Ksh{{ number_format($costAnalysis['total_program_cost'] + $costAnalysis['total_actual_cost'], 2) }}</h4>
                                    <p class="text-muted mb-0">Total Training Cost</p>
                                </div>
                                <div class="col-6">
                                    <h4 class="text-success">Ksh{{ number_format($costAnalysis['avg_cost_per_participant'], 2) }}</h4>
                                    <p class="text-muted mb-0">Cost per Participant</p>
                                </div>
                            </div>
                            <hr>
                            <div class="row text-center">
                                <div class="col-6">
                                    <h6 class="text-info">Ksh{{ number_format($costAnalysis['total_program_cost'], 2) }}</h6>
                                    <small class="text-muted">Program Costs</small>
                                </div>
                                <div class="col-6">
                                    <h6 class="text-warning">Ksh{{ number_format($costAnalysis['avg_cost_per_hour'], 2) }}</h6>
                                    <small class="text-muted">Cost per Hour</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Top Performing Programs -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h5 class="mb-0">Top Performing Programs</h5>
                        </div>
                        <div class="card-body">
                            @if($programPerformance->count() > 0)
                                @foreach($programPerformance->take(5) as $program)
                                    <div class="d-flex justify-content-between align-items-center mb-3">
                                        <div>
                                            <strong>{{ Str::limit($program['title'], 25) }}</strong><br>
                                            <small class="text-muted">{{ $program['sessions_count'] }} sessions, {{ $program['total_enrollments'] }} enrollments</small>
                                        </div>
                                        <div class="text-end">
                                            <span class="badge badge-success">{{ $program['completion_rate'] }}%</span><br>
                                            <small class="text-muted">{{ $program['attendance_rate'] }}% attended</small>
                                        </div>
                                    </div>
                                @endforeach
                            @else
                                <div class="text-center py-3">
                                    <i class="bi bi-trophy fa-2x text-muted mb-2"></i>
                                    <p class="text-muted">No program data available</p>
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>

            <!-- Detailed Sessions Table -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Training Sessions Detail</h5>
                </div>
                <div class="card-body">
                    @if($sessions->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>Program</th>
                                        <th>Category</th>
                                        <th>Session Date</th>
                                        <th>Status</th>
                                        <th>Enrollments</th>
                                        <th>Completed</th>
                                        <th>Attended</th>
                                        <th>No Shows</th>
                                        <th>Completion Rate</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($sessions as $session)
                                        <tr>
                                            <td>
                                                <strong>{{ $session->program->title }}</strong><br>
                                                <small class="text-muted">{{ $session->session_code }}</small>
                                            </td>
                                            <td>
                                                <span class="badge" style="background-color: {{ $session->program->category->color }}">
                                                    {{ $session->program->category->name }}
                                                </span>
                                            </td>
                                            <td>{{ $session->start_datetime->format('M j, Y g:i A') }}</td>
                                            <td>
                                                <span class="badge badge-{{ $session->status == 'completed' ? 'success' : ($session->status == 'in_progress' ? 'warning' : 'primary') }}">
                                                    {{ ucfirst(str_replace('_', ' ', $session->status)) }}
                                                </span>
                                            </td>
                                            <td>{{ $session->enrollments->count() }}</td>
                                            <td>{{ $session->enrollments->where('status', 'completed')->count() }}</td>
                                            <td>{{ $session->enrollments->whereIn('status', ['attended', 'completed'])->count() }}</td>
                                            <td>{{ $session->enrollments->where('status', 'no_show')->count() }}</td>
                                            <td>
                                                @php
                                                    $completionRate = $session->enrollments->count() > 0 
                                                        ? round(($session->enrollments->where('status', 'completed')->count() / $session->enrollments->count()) * 100, 1)
                                                        : 0;
                                                @endphp
                                                <span class="badge badge-{{ $completionRate >= 80 ? 'success' : ($completionRate >= 60 ? 'warning' : 'danger') }}">
                                                    {{ $completionRate }}%
                                                </span>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="bi bi-calendar-times fa-3x text-muted mb-3"></i>
                            <h4>No Training Sessions Found</h4>
                            <p class="text-muted">No training sessions match your current filters for the selected date range.</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection