@extends('layouts.app')

@section('title', 'Edit Role')
@section('page-title', 'Edit Role: ' . ucfirst(str_replace('_', ' ', $role->name)))

@section('content')
    <x-breadcrumb :items="[
        ['label' => 'Dashboard', 'url' => route('dashboard')],
        ['label' => 'Settings', 'url' => route('settings.index')],
        ['label' => 'Roles', 'url' => route('roles.index')],
        ['label' => 'Edit']
    ]" />

    <div class="row">
        <div class="col-md-12">
            <div class="table-card">
                <form action="{{ route('roles.update', $role) }}" method="POST">
                    @csrf
                    @method('PUT')

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label for="name" class="form-label">Role Name (System)</label>
                            <input type="text" class="form-control" id="name" value="{{ $role->name }}" disabled>
                            <small class="text-muted">System name cannot be changed</small>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label for="display_name" class="form-label">Display Name</label>
                            <input type="text" class="form-control" 
                                   id="display_name" value="{{ ucfirst(str_replace('_', ' ', $role->name)) }}" disabled>
                            <small class="text-muted">Display name is auto-generated from role name</small>
                        </div>

                        <div class="col-md-12 mb-3">
                            <label class="form-label">Role Information</label>
                            <x-alert type="info">
                                <strong>{{ ucfirst(str_replace('_', ' ', $role->name)) }}</strong><br>
                                <small>This role has {{ $role->permissions->count() }} permissions assigned.</small>
                            </x-alert>
                        </div>
                    </div>

                    <hr class="my-4">

                    <h6 class="mb-3">Assign Permissions</h6>

                    @foreach($permissions as $group => $groupPermissions)
                        <div class="mb-4">
                            <h6 class="text-primary mb-3">
                                <i class="bi bi-folder"></i> {{ ucwords(str_replace('_', ' ', $group)) }}
                            </h6>
                            <div class="row">
                                @foreach($groupPermissions as $permission)
                                    <div class="col-md-3 mb-2">
                                        <x-form.checkbox 
                                            name="permissions[]" 
                                            :label="ucfirst(str_replace('_', ' ', $permission->name))"
                                            :value="$permission->id"
                                            :checked="in_array($permission->id, old('permissions', $rolePermissions))"
                                            :id="'permission_' . $permission->id" />
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endforeach

                    <x-form.button-group 
                        cancelUrl="{{ route('roles.index') }}"
                        submitText="Update Role"
                        submitIcon="bi-check-circle" />
                </form>
            </div>
        </div>
    </div>
@endsection
