@extends('layouts.app')
@section('title', 'Role Details')
@section('page-title', 'Role: ' . ucfirst(str_replace('_', ' ', $role->name)))
@section('content')
<x-breadcrumb :items="[
    ['label' => 'Dashboard', 'url' => route('dashboard')],
    ['label' => 'Settings', 'url' => route('settings.index')],
    ['label' => 'Roles', 'url' => route('roles.index')],
    ['label' => ucfirst(str_replace('_', ' ', $role->name))]
]" />

<x-alert />

<div class="row">
    <div class="col-md-8">
        <x-info-card>
            <div class="d-flex justify-content-between align-items-center mb-3">
                <h5 class="mb-0">Role Information</h5>
                <div>
                    @if(!in_array($role->name, ['org_admin', 'system_admin']))
                        <a href="{{ route('roles.edit', $role) }}" class="btn btn-sm btn-primary">
                            <i class="bi bi-pencil"></i> Edit Role
                        </a>
                    @endif
                    <a href="{{ route('roles.index') }}" class="btn btn-sm btn-secondary">
                        <i class="bi bi-arrow-left"></i> Back to Roles
                    </a>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <h6>Role Name</h6>
                    <p class="text-muted">{{ $role->name }}</p>
                </div>
                <div class="col-md-6">
                    <h6>Display Name</h6>
                    <p class="text-muted">{{ ucfirst(str_replace('_', ' ', $role->name)) }}</p>
                </div>
                <div class="col-md-6">
                    <h6>Users Count</h6>
                    <p class="text-muted">{{ $role->users->count() }} users assigned</p>
                </div>
                <div class="col-md-6">
                    <h6>Permissions Count</h6>
                    <p class="text-muted">{{ $role->permissions->count() }} permissions assigned</p>
                </div>
            </div>
        </x-info-card>

        <x-info-card title="Assigned Permissions" class="mt-4">
            @if($role->permissions->count() > 0)
                @php
                    $groupedPermissions = $role->permissions->groupBy(function($permission) {
                        $parts = explode('_', $permission->name);
                        return count($parts) > 1 ? $parts[1] : 'general';
                    });
                @endphp
                @foreach($groupedPermissions as $group => $permissions)
                    <div class="mb-4">
                        <h6 class="text-primary mb-3">
                            <i class="bi bi-folder"></i> {{ ucwords(str_replace('_', ' ', $group)) }}
                        </h6>
                        <div class="row">
                            @foreach($permissions as $permission)
                                <div class="col-md-4 mb-2">
                                    <span class="badge bg-success">
                                        {{ ucfirst(str_replace('_', ' ', $permission->name)) }}
                                    </span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endforeach
            @else
                <x-empty-state 
                    icon="shield-x"
                    message="No permissions assigned to this role" />
            @endif
        </x-info-card>
    </div>

    <div class="col-md-4">
        <x-info-card title="Assigned Users">
            @if($role->users->count() > 0)
                <div class="list-group list-group-flush">
                    @foreach($role->users as $user)
                        <div class="list-group-item d-flex justify-content-between align-items-center px-0">
                            <div>
                                <strong>{{ $user->name }}</strong>
                                <br><small class="text-muted">{{ $user->email }}</small>
                            </div>
                            @if($user->organization)
                                <small class="badge bg-info">{{ $user->organization->name }}</small>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <x-empty-state 
                    icon="people"
                    message="No users assigned to this role" />
            @endif
        </x-info-card>

        @if($role->name === 'system_admin')
            <x-info-card class="mt-3">
                <x-alert type="danger" dismissible="false">
                    <i class="bi bi-shield-exclamation"></i>
                    <strong>System Role</strong><br>
                    This is a protected system role with full access to all features.
                </x-alert>
            </x-info-card>
        @elseif($role->name === 'org_admin')
            <x-info-card class="mt-3">
                <x-alert type="warning" dismissible="false">
                    <i class="bi bi-shield-check"></i>
                    <strong>Organization Admin</strong><br>
                    This role has administrative access within their organization.
                </x-alert>
            </x-info-card>
        @endif
    </div>
</div>
@endsection
