@extends('layouts.app')

@section('title', 'Security Dashboard')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h1 class="h3 mb-0">Security Dashboard</h1>
                <div class="btn-group" role="group">
                    <a href="{{ route('security.logs') }}" class="btn btn-outline-primary">
                        <i class="bi bi-file-text"></i> View Logs
                    </a>
                    <a href="{{ route('security.settings') }}" class="btn btn-outline-secondary">
                        <i class="bi bi-gear"></i> Settings
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Security Metrics -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card border-left-danger">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                Failed Logins (7 days)
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $report['failed_logins'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-shield-exclamation fa-2x text-danger"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-left-warning">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Suspicious Inputs
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $report['suspicious_inputs'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-bug fa-2x text-warning"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-left-info">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                New Device Logins
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $report['new_device_logins'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-device-hdd fa-2x text-info"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-3">
            <div class="card border-left-primary">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Rate Limit Violations
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                {{ $report['rate_limit_violations'] }}
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="bi bi-speedometer2 fa-2x text-primary"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Recent Security Alerts -->
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="mb-0">
                        <i class="bi bi-exclamation-triangle text-warning"></i>
                        Recent Security Alerts
                    </h5>
                    <span class="badge badge-secondary">{{ count($alerts) }} alerts</span>
                </div>
                <div class="card-body">
                    @if(empty($alerts))
                        <div class="text-center py-4">
                            <i class="bi bi-shield-check text-success" style="font-size: 3rem;"></i>
                            <h5 class="mt-3 text-muted">No Security Alerts</h5>
                            <p class="text-muted">Your system is secure with no recent alerts.</p>
                        </div>
                    @else
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Alert</th>
                                        <th>Details</th>
                                        <th>IP Address</th>
                                        <th>Time</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($alerts as $alert)
                                        <tr>
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <i class="bi bi-exclamation-triangle text-warning me-2"></i>
                                                    <strong>{{ $alert['title'] }}</strong>
                                                </div>
                                            </td>
                                            <td>
                                                @if(isset($alert['data']['email']))
                                                    <small class="text-muted">Email: {{ $alert['data']['email'] }}</small><br>
                                                @endif
                                                @if(isset($alert['data']['attempts']))
                                                    <small class="text-muted">Attempts: {{ $alert['data']['attempts'] }}</small><br>
                                                @endif
                                                @if(isset($alert['data']['url']))
                                                    <small class="text-muted">URL: {{ $alert['data']['url'] }}</small>
                                                @endif
                                            </td>
                                            <td>
                                                <code>{{ $alert['data']['ip_address'] ?? 'N/A' }}</code>
                                            </td>
                                            <td>
                                                <small class="text-muted">
                                                    {{ $alert['timestamp']->diffForHumans() }}
                                                </small>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button class="btn btn-outline-primary btn-sm" 
                                                            onclick="viewAlertDetails({{ json_encode($alert) }})">
                                                        <i class="bi bi-eye"></i>
                                                    </button>
                                                    @if(isset($alert['data']['ip_address']))
                                                        <button class="btn btn-outline-warning btn-sm"
                                                                onclick="blockIp('{{ $alert['data']['ip_address'] }}')">
                                                            <i class="bi bi-shield-slash"></i>
                                                        </button>
                                                    @endif
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Alert Details Modal -->
<div class="modal fade" id="alertDetailsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Security Alert Details</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="alertDetailsContent"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<style>
.border-left-danger {
    border-left: 4px solid #dc3545 !important;
}
.border-left-warning {
    border-left: 4px solid #ffc107 !important;
}
.border-left-info {
    border-left: 4px solid #17a2b8 !important;
}
.border-left-primary {
    border-left: 4px solid #007bff !important;
}
</style>

<script>
function viewAlertDetails(alert) {
    const content = `
        <div class="row">
            <div class="col-md-6">
                <h6>Alert Information</h6>
                <table class="table table-sm">
                    <tr><td><strong>Title:</strong></td><td>${alert.title}</td></tr>
                    <tr><td><strong>Time:</strong></td><td>${new Date(alert.timestamp).toLocaleString()}</td></tr>
                </table>
            </div>
            <div class="col-md-6">
                <h6>Details</h6>
                <pre class="bg-light p-2 rounded"><code>${JSON.stringify(alert.data, null, 2)}</code></pre>
            </div>
        </div>
    `;
    
    document.getElementById('alertDetailsContent').innerHTML = content;
    new bootstrap.Modal(document.getElementById('alertDetailsModal')).show();
}

function blockIp(ip) {
    if (confirm(`Are you sure you want to block IP address ${ip}?`)) {
        // In a real implementation, you'd make an AJAX call to block the IP
        alert('IP blocking functionality would be implemented here');
    }
}
</script>
@endsection