@extends('layouts.app')

@section('title', 'Settings')
@section('page-title', 'Settings')

@section('content')
<div class="container-fluid">
    <div class="row">
        <!-- Company Settings -->
        @can('view_organization_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.organization') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(113, 75, 103, 0.1); color: #714b67;">
                        <i class="bi bi-building" style="font-size: 40px;"></i>
                    </div>
                    <h5>Organization Settings</h5>
                    <p class="text-muted mb-0">Manage organization information</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Leave Types -->
        @can('edit_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.leave-types') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(0, 160, 157, 0.1); color: #00a09d;">
                        <i class="bi bi-calendar-range" style="font-size: 40px;"></i>
                    </div>
                    <h5>Leave Types</h5>
                    <p class="text-muted mb-0">Configure leave types and policies</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Attendance Settings -->
        @can('edit_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.attendance') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(23, 162, 184, 0.1); color: #17a2b8;">
                        <i class="bi bi-clock-history" style="font-size: 40px;"></i>
                    </div>
                    <h5>Attendance Settings</h5>
                    <p class="text-muted mb-0">Configure check-in/check-out rules</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Payroll Settings -->
        @can('edit_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('payroll.settings.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(102, 16, 242, 0.1); color: #6610f2;">
                        <i class="bi bi-calculator" style="font-size: 40px;"></i>
                    </div>
                    <h5>Payroll Settings</h5>
                    <p class="text-muted mb-0">Configure tax rates and deductions</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Loan Settings -->
        @can('edit_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('loan-settings.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(255, 99, 132, 0.1); color: #ff6384;">
                        <i class="bi bi-bank" style="font-size: 40px;"></i>
                    </div>
                    <h5>Loan Policies</h5>
                    <p class="text-muted mb-0">Configure loan rules and limits</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Positions -->
        @can('edit_departments')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.positions') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(40, 167, 69, 0.1); color: #28a745;">
                        <i class="bi bi-briefcase" style="font-size: 40px;"></i>
                    </div>
                    <h5>Positions</h5>
                    <p class="text-muted mb-0">Manage job positions and roles</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Holidays -->
        @can('edit_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.holidays') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(220, 53, 69, 0.1); color: #dc3545;">
                        <i class="bi bi-calendar-event" style="font-size: 40px;"></i>
                    </div>
                    <h5>Holidays</h5>
                    <p class="text-muted mb-0">Configure public and company holidays</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Theme & Branding -->
        @role('org_admin')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.theme.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(255, 107, 53, 0.1); color: #FF6B35;">
                        <i class="bi bi-palette" style="font-size: 40px;"></i>
                    </div>
                    <h5>Theme & Branding</h5>
                    <p class="text-muted mb-0">Customize colors, logos, and fonts</p>
                </div>
            </a>
        </div>
        @endrole

        <!-- Email Settings -->
        @can('edit_organization_settings')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('settings.email.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(13, 110, 253, 0.1); color: #0d6efd;">
                        <i class="bi bi-envelope-at" style="font-size: 40px;"></i>
                    </div>
                    <h5>Email Settings</h5>
                    <p class="text-muted mb-0">Configure organization email for recruitment</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Roles & Permissions -->
        @can('manage_roles')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('roles.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(255, 193, 7, 0.1); color: #ffc107;">
                        <i class="bi bi-shield-lock" style="font-size: 40px;"></i>
                    </div>
                    <h5>Roles & Permissions</h5>
                    <p class="text-muted mb-0">Manage user roles and access control</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- User Management -->
        @can('view_users')
        <div class="col-md-6 col-lg-4 mb-4">
            <a href="{{ route('users.index') }}" class="text-decoration-none">
                <div class="table-card text-center hover-shadow" style="cursor: pointer;">
                    <div class="stat-icon mx-auto mb-3" style="width: 80px; height: 80px; background: rgba(108, 117, 125, 0.1); color: #6c757d;">
                        <i class="bi bi-person-gear" style="font-size: 40px;"></i>
                    </div>
                    <h5>User Management</h5>
                    <p class="text-muted mb-0">Manage users and assign roles</p>
                </div>
            </a>
        </div>
        @endcan

        <!-- Show message if no settings are available -->
        @if(!auth()->user()->can('view_organization_settings') && 
            !auth()->user()->can('edit_settings') && 
            !auth()->user()->can('edit_departments') && 
            !auth()->user()->can('manage_roles') && 
            !auth()->user()->can('view_users'))
        <div class="col-12">
            <div class="table-card text-center">
                <div class="py-5">
                    <i class="bi bi-lock text-muted" style="font-size: 3rem;"></i>
                    <h5 class="mt-3 text-muted">Access Restricted</h5>
                    <p class="text-muted">You don't have permission to access any settings. Contact your administrator for access.</p>
                </div>
            </div>
        </div>
        @endif
    </div>
</div>

@push('styles')
<style>
    .hover-shadow {
        transition: all 0.3s ease;
    }
    .hover-shadow:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.15) !important;
    }
    .stat-icon {
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>
@endpush
@endsection
