@extends('layouts.app')

@section('title', 'Theme & Branding')
@section('page-title', 'Theme & Branding')

@push('styles')
<style>
    .theme-card {
        border: 2px solid #e0e0e0;
        border-radius: 12px;
        cursor: pointer;
        transition: all 0.3s ease;
        overflow: hidden;
    }
    
    .theme-card:hover {
        border-color: var(--color-primary);
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    }
    
    .theme-card.active {
        border-color: var(--color-primary);
        border-width: 3px;
        box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    }
    
    .theme-preview {
        height: 150px;
        position: relative;
        display: flex;
    }
    
    .theme-preview-sidebar {
        width: 30%;
        height: 100%;
    }
    
    .theme-preview-content {
        flex: 1;
        padding: 10px;
        background: #f5f5f5;
    }
    
    .theme-preview-header {
        height: 20px;
        background: white;
        border-radius: 4px;
        margin-bottom: 8px;
    }
    
    .theme-preview-cards {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 6px;
    }
    
    .theme-preview-cards::before,
    .theme-preview-cards::after {
        content: '';
        height: 40px;
        background: white;
        border-radius: 4px;
    }
    
    .theme-card-body {
        padding: 15px;
        background: white;
        text-align: center;
    }
    
    .theme-card-body h6 {
        margin-bottom: 10px;
        font-weight: 600;
    }
    
    .logo-preview {
        position: relative;
        display: inline-block;
        margin-bottom: 10px;
    }
    
    .logo-preview img {
        max-height: 100px;
        max-width: 200px;
    }
    
    .logo-preview .delete-logo {
        position: absolute;
        top: -8px;
        right: -8px;
    }
    
    .color-input-group {
        display: flex;
        gap: 8px;
        align-items: center;
    }
    
    .color-input-group input[type="color"] {
        width: 50px;
        height: 38px;
        border: 1px solid #ced4da;
        border-radius: 0.375rem;
        cursor: pointer;
    }
    
    .font-preview {
        padding: 10px;
        background: #f8f9fa;
        border-radius: 4px;
        border: 1px solid #dee2e6;
    }
</style>
@endpush

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <!-- Breadcrumb -->
            <nav aria-label="breadcrumb" class="mb-3">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('settings.index') }}">Settings</a></li>
                    <li class="breadcrumb-item active">Theme & Branding</li>
                </ol>
            </nav>

            <form action="{{ route('settings.theme.update') }}" method="POST" enctype="multipart/form-data">
                @csrf
                
                <!-- Preset Themes Section -->
                @include('settings.theme.partials.preset-themes')
                
                <!-- Color Customization Section -->
                @include('settings.theme.partials.color-picker')
                
                <!-- Logo Management Section -->
                @include('settings.theme.partials.logo-upload')
                
                <!-- Font Selection Section -->
                @include('settings.theme.partials.font-selector')
                
                <!-- Layout Preferences Section -->
                <div class="card mb-4">
                    <div class="card-header">
                        <h5 class="mb-0">Layout Preferences</h5>
                    </div>
                    <div class="card-body">
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" 
                                   name="sidebar_collapsed_default" 
                                   id="sidebarCollapsed"
                                   {{ $themeSetting?->sidebar_collapsed_default ? 'checked' : '' }}>
                            <label class="form-check-label" for="sidebarCollapsed">
                                Sidebar collapsed by default
                            </label>
                        </div>
                        
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" 
                                   name="dark_mode_enabled" 
                                   id="darkMode"
                                   {{ $themeSetting?->dark_mode_enabled ? 'checked' : '' }}
                                   disabled>
                            <label class="form-check-label" for="darkMode">
                                Enable dark mode <span class="badge bg-secondary">Coming Soon</span>
                            </label>
                        </div>
                    </div>
                </div>
                
                <!-- Custom CSS Section -->
                @include('settings.theme.partials.custom-css')
                
                <!-- Action Buttons -->
                <div class="card">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-center flex-wrap gap-2">
                            <div>
                                <button type="button" class="btn btn-outline-warning" id="resetTheme">
                                    <i class="bi bi-arrow-counterclockwise"></i> Reset to Base Theme
                                </button>
                            </div>
                            <div>
                                <a href="{{ route('settings.index') }}" class="btn btn-secondary">
                                    <i class="bi bi-x-circle"></i> Cancel
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save"></i> Save Theme
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Reset Confirmation Form -->
<form id="resetForm" action="{{ route('settings.theme.reset') }}" method="POST" style="display: none;">
    @csrf
</form>
@endsection

@push('scripts')
<script src="{{ asset('js/theme-manager.js') }}"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Theme selection
    document.querySelectorAll('.theme-card').forEach(card => {
        card.addEventListener('click', function() {
            document.querySelectorAll('.theme-card').forEach(c => c.classList.remove('active'));
            this.classList.add('active');
            document.querySelector('input[name="base_theme"]').value = this.dataset.theme;
        });
    });
    
    // Color picker sync
    document.querySelectorAll('.color-input-group').forEach(group => {
        const colorPicker = group.querySelector('input[type="color"]');
        const textInput = group.querySelector('input[type="text"]');
        const resetBtn = group.querySelector('.reset-color');
        
        if (colorPicker && textInput) {
            colorPicker.addEventListener('input', function() {
                textInput.value = this.value.toUpperCase();
            });
            
            textInput.addEventListener('input', function() {
                if (/^#[0-9A-F]{6}$/i.test(this.value)) {
                    colorPicker.value = this.value;
                }
            });
        }
        
        if (resetBtn) {
            resetBtn.addEventListener('click', function() {
                textInput.value = '';
                colorPicker.value = '#000000';
            });
        }
    });
    
    // Reset theme
    document.getElementById('resetTheme')?.addEventListener('click', function() {
        if (confirm('Reset all customizations to base theme? This will keep your logos but remove all color and font customizations.')) {
            document.getElementById('resetForm').submit();
        }
    });
    
    // Font preview update
    document.querySelectorAll('select[name$="_font"]').forEach(select => {
        select.addEventListener('change', function() {
            const preview = this.closest('.mb-3').querySelector('.font-preview');
            if (preview) {
                preview.style.fontFamily = this.value || 'inherit';
            }
        });
    });
});
</script>
@endpush
