<div class="card mb-4">
    <div class="card-header">
        <h5 class="mb-0">Logo Management</h5>
        <p class="text-muted mb-0 small">Upload your organization logos</p>
    </div>
    <div class="card-body">
        <div class="row">
            <!-- Main Logo -->
            <div class="col-md-6 mb-4">
                <label class="form-label fw-bold">Main Logo</label>
                <p class="text-muted small mb-2">Recommended: 200x60px, PNG with transparency</p>
                
                @if($themeSetting?->logo_url)
                <div class="logo-preview mb-2">
                    <img src="{{ $themeSetting->logo_url }}" alt="Main Logo" class="img-thumbnail">
                    <button type="button" class="btn btn-sm btn-danger delete-logo" data-type="logo">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @endif
                
                <input type="file" class="form-control" name="logo" accept="image/*">
            </div>
            
            <!-- Sidebar Logo -->
            <div class="col-md-6 mb-4">
                <label class="form-label fw-bold">Sidebar Logo</label>
                <p class="text-muted small mb-2">Recommended: 44x44px, Square format</p>
                
                @if($themeSetting?->sidebar_logo_url)
                <div class="logo-preview mb-2">
                    <img src="{{ $themeSetting->sidebar_logo_url }}" alt="Sidebar Logo" class="img-thumbnail">
                    <button type="button" class="btn btn-sm btn-danger delete-logo" data-type="sidebar_logo">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @endif
                
                <input type="file" class="form-control" name="sidebar_logo" accept="image/*">
            </div>
            
            <!-- Header Logo -->
            <div class="col-md-6 mb-4">
                <label class="form-label fw-bold">Header Logo</label>
                <p class="text-muted small mb-2">Recommended: Height 28px, Horizontal format</p>
                
                @if($themeSetting?->header_logo_url)
                <div class="logo-preview mb-2">
                    <img src="{{ $themeSetting->header_logo_url }}" alt="Header Logo" class="img-thumbnail">
                    <button type="button" class="btn btn-sm btn-danger delete-logo" data-type="header_logo">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @endif
                
                <input type="file" class="form-control" name="header_logo" accept="image/*">
            </div>
            
            <!-- Favicon -->
            <div class="col-md-6 mb-4">
                <label class="form-label fw-bold">Favicon</label>
                <p class="text-muted small mb-2">Recommended: 32x32px, ICO or PNG format</p>
                
                @if($themeSetting?->favicon_url)
                <div class="logo-preview mb-2">
                    <img src="{{ $themeSetting->favicon_url }}" alt="Favicon" class="img-thumbnail">
                    <button type="button" class="btn btn-sm btn-danger delete-logo" data-type="favicon">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @endif
                
                <input type="file" class="form-control" name="favicon" accept="image/x-icon,image/png">
            </div>
            
            <!-- Login Banner -->
            <div class="col-12 mb-4">
                <label class="form-label fw-bold">Login Page Banner</label>
                <p class="text-muted small mb-2">Recommended: 1200x400px, JPG or PNG</p>
                
                @if($themeSetting?->login_banner_url)
                <div class="logo-preview mb-2">
                    <img src="{{ $themeSetting->login_banner_url }}" alt="Login Banner" class="img-thumbnail" style="max-width: 100%;">
                    <button type="button" class="btn btn-sm btn-danger delete-logo" data-type="login_banner">
                        <i class="bi bi-trash"></i>
                    </button>
                </div>
                @endif
                
                <input type="file" class="form-control" name="login_banner" accept="image/*">
            </div>
        </div>
        
        <div class="alert alert-warning">
            <i class="bi bi-exclamation-triangle"></i>
            <strong>Note:</strong> Uploading a new logo will replace the existing one. 
            Maximum file size: 2MB for logos, 4MB for banner.
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Delete logo
    document.querySelectorAll('.delete-logo').forEach(btn => {
        btn.addEventListener('click', function() {
            const type = this.dataset.type;
            if (confirm('Delete this logo?')) {
                fetch(`/settings/theme/delete-logo/${type}`, {
                    method: 'DELETE',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        location.reload();
                    }
                })
                .catch(error => {
                    alert('Error deleting logo');
                    console.error(error);
                });
            }
        });
    });
    
    // Preview uploaded images
    document.querySelectorAll('input[type="file"]').forEach(input => {
        input.addEventListener('change', function() {
            const file = this.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    // Remove existing preview if any
                    const existingPreview = input.parentElement.querySelector('.upload-preview');
                    if (existingPreview) {
                        existingPreview.remove();
                    }
                    
                    // Create new preview
                    const preview = document.createElement('div');
                    preview.className = 'upload-preview mt-2';
                    preview.innerHTML = `
                        <img src="${e.target.result}" class="img-thumbnail" style="max-height: 100px; max-width: 200px;">
                        <small class="d-block text-muted mt-1">Preview (not saved yet)</small>
                    `;
                    input.parentElement.appendChild(preview);
                };
                reader.readAsDataURL(file);
            }
        });
    });
});
</script>
@endpush
