@extends('systemadmin.layouts.app')

@section('title', 'Dashboard')
@section('page-title', 'SystemAdmin Dashboard')

@section('content')
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0">{{ $stats['total_organizations'] }}</h3>
                        <p class="mb-0">Total Organizations</p>
                    </div>
                    <i class="bi bi-building stat-icon"></i>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0">{{ $stats['active_organizations'] }}</h3>
                        <p class="mb-0">Active Organizations</p>
                    </div>
                    <i class="bi bi-check-circle stat-icon"></i>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0">{{ $stats['total_users'] }}</h3>
                        <p class="mb-0">Total Users</p>
                    </div>
                    <i class="bi bi-people stat-icon"></i>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card stat-card">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <h3 class="mb-0">{{ $stats['total_employees'] }}</h3>
                        <p class="mb-0">Total Employees</p>
                    </div>
                    <i class="bi bi-person-badge stat-icon"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8 mb-4">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0">Recent Organizations</h5>
                <a href="{{ route('systemadmin.organizations.index') }}" class="btn btn-sm btn-outline-primary">
                    <i class="bi bi-eye"></i> View All
                </a>
            </div>
            <div class="card-body">
                @if($stats['recent_organizations']->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>Status</th>
                                    <th>Created</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($stats['recent_organizations'] as $org)
                                <tr>
                                    <td>
                                        <div>
                                            <strong>{{ $org->name }}</strong>
                                            <br><small class="text-muted">{{ $org->slug }}</small>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $org->status === 'active' ? 'success' : ($org->status === 'inactive' ? 'secondary' : 'danger') }}">
                                            {{ ucfirst($org->status) }}
                                        </span>
                                    </td>
                                    <td>{{ $org->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <a href="{{ route('systemadmin.organizations.show', $org) }}" 
                                           class="btn btn-sm btn-outline-primary">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @else
                    <div class="text-center py-4">
                        <i class="bi bi-building display-4 text-muted"></i>
                        <p class="text-muted mt-2">No organizations created yet</p>
                        <a href="{{ route('systemadmin.organizations.create') }}" class="btn btn-primary">
                            <i class="bi bi-plus"></i> Create First Organization
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card mb-4">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-lightning-charge"></i> Quick Actions
                </h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('systemadmin.organizations.create') }}" class="btn btn-primary">
                        <i class="bi bi-plus"></i> Create Organization
                    </a>
                    <a href="{{ route('systemadmin.organizations.index') }}" class="btn btn-outline-primary">
                        <i class="bi bi-building"></i> Manage Organizations
                    </a>
                    <button class="btn btn-outline-secondary" disabled>
                        <i class="bi bi-people"></i> System Users
                        <small class="d-block">Coming Soon</small>
                    </button>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">
                    <i class="bi bi-info-circle"></i> System Overview
                </h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-6">
                        <div class="border-end pe-3">
                            <h4 style="color: #FF6B35;">{{ $stats['active_organizations'] }}</h4>
                            <small class="text-muted">Active Orgs</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="ps-3">
                            <h4 style="color: #030213;">{{ $stats['total_users'] }}</h4>
                            <small class="text-muted">Total Users</small>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="row text-center">
                    <div class="col-12">
                        <h5 style="color: #FF6B35;">{{ $stats['total_employees'] }}</h5>
                        <small class="text-muted">Total Employees Across All Organizations</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<style>
    /* Additional mobile responsive styles for dashboard */
    @media (max-width: 575.98px) {
        .card-header {
            padding: 15px;
        }
        
        .card-header h5 {
            font-size: 1rem;
        }
        
        .btn-sm {
            font-size: 0.8rem;
            padding: 0.25rem 0.5rem;
        }
        
        .table-responsive {
            font-size: 0.9rem;
        }
        
        .stat-card h3 {
            font-size: 1.5rem;
        }
        
        .stat-card p {
            font-size: 0.9rem;
        }
    }
    
    /* Tablet adjustments */
    @media (min-width: 768px) and (max-width: 991.98px) {
        .stat-card {
            margin-bottom: 20px;
        }
    }
</style>
@endpush
@endsection